/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class NbtHelpers {
    public static boolean nbtMatchesSubset(CompoundNBT a, CompoundNBT b, boolean recursive) {
        for (String key : a.func_150296_c()) {
            INBT valueA = a.func_74781_a(key);
            if (recursive && (valueA instanceof CompoundNBT || valueA instanceof ListNBT)) {
                CompoundNBT tagB;
                CompoundNBT tagA;
                INBT valueB = b.func_74781_a(key);
                if (valueA instanceof CompoundNBT) {
                    if (!(valueB instanceof CompoundNBT)) {
                        return false;
                    }
                    tagA = (CompoundNBT)valueA;
                    tagB = (CompoundNBT)valueB;
                    if (NbtHelpers.nbtMatchesSubset(tagA, tagB, recursive)) continue;
                    return false;
                }
                if (!(valueA instanceof ListNBT)) continue;
                if (!(valueB instanceof ListNBT)) {
                    return false;
                }
                tagA = (ListNBT)valueA;
                tagB = (ListNBT)valueB;
                for (int i = 0; i < tagA.size(); ++i) {
                    CompoundNBT subTagA = tagA.func_150305_b(i);
                    boolean foundA = false;
                    for (int j = 0; j < tagB.size(); ++j) {
                        CompoundNBT subTagB = tagB.func_150305_b(j);
                        if (!NbtHelpers.nbtMatchesSubset(subTagA, subTagB, recursive)) continue;
                        foundA = true;
                        break;
                    }
                    if (foundA) continue;
                    return false;
                }
                continue;
            }
            if (valueA.equals(b.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    public static CompoundNBT union(CompoundNBT ... tags) {
        CompoundNBT tag = new CompoundNBT();
        for (CompoundNBT inputTag : tags) {
            tag.func_197643_a(inputTag);
        }
        return tag;
    }

    public static CompoundNBT intersection(CompoundNBT ... tags) {
        if (tags.length == 0) {
            return new CompoundNBT();
        }
        CompoundNBT tag = null;
        for (CompoundNBT inputTag : tags) {
            if (tag == null) {
                tag = inputTag.func_74737_b();
                continue;
            }
            HashSet keys = Sets.newHashSet((Iterable)tag.func_150296_c());
            for (String key : keys) {
                byte type;
                if (!inputTag.func_150297_b(key, (int)(type = tag.func_74781_a(key).func_74732_a()))) {
                    tag.func_82580_o(key);
                    continue;
                }
                if (type != 10) continue;
                tag.func_218657_a(key, (INBT)NbtHelpers.intersection(tag.func_74775_l(key), inputTag.func_74775_l(key)));
            }
        }
        return tag;
    }

    public static CompoundNBT minus(CompoundNBT a, CompoundNBT b) {
        CompoundNBT tag = a.func_74737_b();
        for (String key : b.func_150296_c()) {
            byte type;
            if (!tag.func_150297_b(key, (int)(type = b.func_74781_a(key).func_74732_a()))) continue;
            if (type == 10) {
                CompoundNBT difference = NbtHelpers.minus(tag.func_74775_l(key), b.func_74775_l(key));
                if (difference.isEmpty()) {
                    tag.func_82580_o(key);
                    continue;
                }
                tag.func_218657_a(key, (INBT)difference);
                continue;
            }
            tag.func_82580_o(key);
        }
        return tag;
    }

    public static ListNBT getListNbtTag(ValueTypeList.ValueList<?, ?> value, ITextComponent operatorName) {
        ListNBT list = new ListNBT();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.NBT) {
                TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, value.getType(), 1, ValueTypes.NBT});
                Helpers.sneakyThrow(new EvaluationException((ITextComponent)error));
            }
            ((ValueTypeNbt.ValueNbt)valueNbt).getRawValue().ifPresent(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static ByteArrayNBT getListNbtByte(ValueTypeList.ValueList<?, ?> value, ITextComponent operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.INTEGER) {
                TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, value.getType(), 1, ValueTypes.INTEGER});
                Helpers.sneakyThrow(new EvaluationException((ITextComponent)error));
            }
            list.add((byte)((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new ByteArrayNBT((List)list);
    }

    public static IntArrayNBT getListNbtInt(ValueTypeList.ValueList<?, ?> value, ITextComponent operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.INTEGER) {
                TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, value.getType(), 1, ValueTypes.INTEGER});
                Helpers.sneakyThrow(new EvaluationException((ITextComponent)error));
            }
            list.add(((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new IntArrayNBT((List)list);
    }

    public static LongArrayNBT getListNbtLong(ValueTypeList.ValueList<?, ?> value, ITextComponent operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.LONG) {
                TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{operatorName, value.getType(), 1, ValueTypes.LONG});
                Helpers.sneakyThrow(new EvaluationException((ITextComponent)error));
            }
            list.add(((ValueTypeLong.ValueLong)valueNbt).getRawValue());
        }
        return new LongArrayNBT((List)list);
    }
}

