/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemPart<P extends IPartType<P, S>, S extends IPartState<P>>
extends Item {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();
    private final IPartType<P, S> part;

    public ItemPart(Item.Properties properties, IPartType<P, S> part) {
        super(properties);
        this.part = part;
    }

    public String func_77658_a() {
        return this.part.getTranslationKey();
    }

    public String func_77667_c(ItemStack stack) {
        return this.part.getTranslationKey();
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack itemStack = player.func_184586_b(hand);
        IPartContainer partContainerFirst = (IPartContainer)PartHelpers.getPartContainer((IBlockReader)world, pos, side).orElse(null);
        if (partContainerFirst != null) {
            if (PartHelpers.addPart(world, pos, side, this.getPart(), itemStack)) {
                if (world.func_201670_d()) {
                    ItemBlockCable.playPlaceSound(world, pos);
                }
                if (!player.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        BlockPos target = pos.func_177972_a(side);
        Direction targetSide = side.func_176734_d();
        BlockRayTraceResult targetRayTrace = new BlockRayTraceResult(new Vec3d((double)target.func_177958_n() + 0.5 + (double)targetSide.func_82601_c() * 0.5, (double)target.func_177956_o() + 0.5 + (double)targetSide.func_96559_d() * 0.5, (double)target.func_177952_p() + 0.5 + (double)targetSide.func_82599_e() * 0.5), targetSide, target, false);
        if (world.func_180495_p(target).func_177230_c().func_196253_a(world.func_180495_p(target), new BlockItemUseContext(world, player, hand, itemStack, targetRayTrace))) {
            IPartContainer partContainer;
            ItemBlockCable itemBlockCable = (ItemBlockCable)Item.func_150898_a((Block)RegistryEntries.BLOCK_CABLE);
            itemStack.func_190917_f(1);
            if (itemBlockCable.func_195939_a(new ItemUseContext(player, hand, targetRayTrace)) == ActionResultType.SUCCESS && (partContainer = (IPartContainer)PartHelpers.getPartContainer((IBlockReader)world, target, targetSide).orElse(null)) != null) {
                ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((IBlockReader)world, target, targetSide).orElse(null);
                if (!world.func_201670_d()) {
                    PartHelpers.addPart(world, target, side.func_176734_d(), this.getPart(), itemStack);
                    if (cableFakeable != null) {
                        CableHelpers.onCableRemoving(world, target, false, false);
                        cableFakeable.setRealCable(false);
                        CableHelpers.onCableRemoved(world, target, CableHelpers.ALL_SIDES);
                    } else {
                        IntegratedDynamics.clog(Level.WARN, String.format("Tried to set a fake cable at a block that is not fakeable at %s", target));
                    }
                } else {
                    cableFakeable.setRealCable(false);
                }
                itemStack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            itemStack.func_190918_g(1);
        } else {
            IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer((IBlockReader)world, target, targetSide).orElse(null);
            if (partContainer != null) {
                if (PartHelpers.addPart(world, target, side.func_176734_d(), this.getPart(), itemStack)) {
                    if (world.func_201670_d()) {
                        ItemBlockCable.playPlaceSound(world, target);
                    }
                    if (!player.func_184812_l_()) {
                        itemStack.func_190918_g(1);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.attempItemUseTarget(this, itemStack, world, pos, side)) continue;
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_150297_b("id", 3)) {
            int id = itemStack.func_77978_p().func_74762_e("id");
            list.add((ITextComponent)new TranslationTextComponent("item.integrateddynamics.general.id", new Object[]{id}));
        }
        this.getPart().loadTooltip(itemStack, list);
        super.func_77624_a(itemStack, world, list, flag);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemPart)) {
            return false;
        }
        ItemPart other = (ItemPart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IPartType<P, S> this$part = this.getPart();
        IPartType<P, S> other$part = other.getPart();
        return !(this$part == null ? other$part != null : !this$part.equals(other$part));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemPart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPartType<P, S> $part = this.getPart();
        result = result * 59 + ($part == null ? 0 : $part.hashCode());
        return result;
    }

    public IPartType<P, S> getPart() {
        return this.part;
    }

    public String toString() {
        return "ItemPart(part=" + this.getPart() + ")";
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemPart var1, ItemStack var2, World var3, BlockPos var4, Direction var5);
    }
}

