/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import java.beans.ConstructorProperties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import org.cyclops.integrateddynamics.core.network.diagnostics.IRawData;

public class RawPartData
implements IRawData {
    private final DimensionType dimension;
    private final BlockPos pos;
    private final Direction side;
    private final String name;
    private final long last20TicksDurationNs;

    public String toString() {
        return String.format("%s: %s,%s,%s,%s (%s)", this.name, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.side, this.dimension);
    }

    public CompoundNBT toNbt() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("dimension", this.dimension.getRegistryName().toString());
        tag.func_74772_a("pos", this.pos.func_218275_a());
        tag.func_74768_a("side", this.side.ordinal());
        tag.func_74778_a("name", this.name);
        tag.func_74772_a("last20TicksDurationNs", this.last20TicksDurationNs);
        return tag;
    }

    public static RawPartData fromNbt(CompoundNBT tag) {
        return new RawPartData(DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tag.func_74779_i("dimension"))), BlockPos.func_218283_e((long)tag.func_74763_f("pos")), Direction.values()[tag.func_74762_e("side")], tag.func_74779_i("name"), tag.func_74763_f("last20TicksDurationNs"));
    }

    @ConstructorProperties(value={"dimension", "pos", "side", "name", "last20TicksDurationNs"})
    public RawPartData(DimensionType dimension, BlockPos pos, Direction side, String name, long last20TicksDurationNs) {
        this.dimension = dimension;
        this.pos = pos;
        this.side = side;
        this.name = name;
        this.last20TicksDurationNs = last20TicksDurationNs;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public String getName() {
        return this.name;
    }

    public long getLast20TicksDurationNs() {
        return this.last20TicksDurationNs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawPartData)) {
            return false;
        }
        RawPartData other = (RawPartData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DimensionType this$dimension = this.getDimension();
        DimensionType other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Direction this$side = this.getSide();
        Direction other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawPartData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DimensionType $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 0 : $dimension.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        Direction $side = this.getSide();
        result = result * 59 + ($side == null ? 0 : $side.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        long $last20TicksDurationNs = this.getLast20TicksDurationNs();
        result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
        return result;
    }
}

