/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class LootFunctionCopyEnergyBatteryData
implements ILootFunction {
    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        TileEntity tile = (TileEntity)lootContext.func_216031_c(LootParameters.field_216288_h);
        if (tile instanceof TileEnergyBattery) {
            itemStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                ((IEnergyStorageMutable)energyStorage).setEnergy(((TileEnergyBattery)tile).getEnergyStored());
                ((IEnergyStorageCapacity)energyStorage).setCapacity(((TileEnergyBattery)tile).getMaxEnergyStored());
            });
        }
        return itemStack;
    }

    public static class Serializer
    extends ILootFunction.Serializer<LootFunctionCopyEnergyBatteryData> {
        public Serializer() {
            super(new ResourceLocation("integrateddynamics", "copy_energy_battery_data"), LootFunctionCopyEnergyBatteryData.class);
        }

        public void serialize(JsonObject jsonObject, LootFunctionCopyEnergyBatteryData lootFunctionCopyId, JsonSerializationContext jsonSerializationContext) {
        }

        public LootFunctionCopyEnergyBatteryData deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new LootFunctionCopyEnergyBatteryData();
        }
    }
}

