/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.ProxyVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ProxyVariableFacade;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerProxy;
import org.cyclops.integrateddynamics.network.ProxyNetworkElement;

public class TileProxy
extends TileActiveVariableBase<ProxyNetworkElement>
implements INamedContainerProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    public static final String GLOBALCOUNTER_KEY = "proxy";
    @NBTPersist
    private int proxyId = -1;
    private PlayerEntity lastPlayer = null;

    public TileProxy() {
        this(RegistryEntries.TILE_ENTITY_PROXY, 3);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{1})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, LazyOptional.of(() -> new ItemHandlerSlotMasked((IInventory)this.getInventory(), new int[]{2})));
    }

    public TileProxy(TileEntityType<?> type, int inventorySize) {
        super(type, inventorySize);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new ProxyNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        }));
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean func_94041_b(int slot, ItemStack itemStack) {
                return slot != 2 && super.func_94041_b(slot, itemStack);
            }
        };
    }

    @Override
    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((IInventory)this.getInventory(), this.getSlotRead(), (IValueType)ValueTypes.CATEGORY_ANY){

            @Override
            protected void preValidate() {
                super.preValidate();
                if (this.getVariableFacade() instanceof IProxyVariableFacade && ((IProxyVariableFacade)this.getVariableFacade()).getProxyId() == TileProxy.this.getProxyId()) {
                    this.addError((ITextComponent)new TranslationTextComponent("variable.integrateddynamics.error.recursion", new Object[]{this.getVariableFacade().getId()}));
                }
            }
        };
    }

    public void generateNewProxyId() {
        this.proxyId = IntegratedDynamics.globalCounters.getNext(GLOBALCOUNTER_KEY);
        this.func_70296_d();
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected int getSlotWriteIn() {
        return 1;
    }

    protected int getSlotWriteOut() {
        return 2;
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.field_145850_b.func_201670_d() && !this.getInventory().func_70301_a(this.getSlotWriteIn()).func_190926_b() && this.getInventory().func_70301_a(this.getSlotWriteOut()).func_190926_b()) {
            ItemStack outputStack = this.writeProxyInfo(!this.func_145831_w().field_72995_K, this.getInventory().func_70304_b(this.getSlotWriteIn()), this.proxyId);
            this.getInventory().func_70299_a(this.getSlotWriteOut(), outputStack);
        }
    }

    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, ProxyVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IProxyVariableFacade>(){

            @Override
            public IProxyVariableFacade create(boolean generateId) {
                return new ProxyVariableFacade(generateId, proxyId);
            }

            @Override
            public IProxyVariableFacade create(int id) {
                return new ProxyVariableFacade(id, proxyId);
            }
        }, this.lastPlayer, this.func_195044_w());
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerProxy(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.proxy", new Object[0]);
    }

    public int getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(int proxyId) {
        this.proxyId = proxyId;
    }

    public void setLastPlayer(PlayerEntity lastPlayer) {
        this.lastPlayer = lastPlayer;
    }
}

