/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.biome;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.BiomeConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.world.biome.BiomeMeneglin;

public class BiomeMeneglinConfig
extends BiomeConfig {
    @ConfigurableProperty(category="biome", comment="The weight of spawning.", minimalValue=0)
    public static int spawnWeight = 5;
    @ConfigurableProperty(category="worldgeneration", comment="List of dimension IDs in which the meneglin biome should not generate.")
    public static List<String> meneglinBiomeDimensionBlacklist = Lists.newArrayList((Object[])new String[]{"minecraft:nether", "minecraft:the_end"});

    public BiomeMeneglinConfig() {
        super((ModBase)IntegratedDynamics._instance, "meneglin", eConfig -> new BiomeMeneglin());
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        Biome biome = (Biome)this.getInstance();
        if (spawnWeight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, spawnWeight));
        }
        BiomeManager.addSpawnBiome((Biome)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.MAGICAL});
    }
}

