/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.gen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.block.BlockMenrilLogFilled;

public class WorldFeatureTreeMenril
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public WorldFeatureTreeMenril(Function<Dynamic<?>, TreeFeatureConfig> configIn) {
        super(configIn);
    }

    protected int baseHeight() {
        return 7;
    }

    protected int baseHeightRandomRange() {
        return 4;
    }

    protected boolean func_225557_a_(IWorldGenerationReader world, Random rand, BlockPos blockPos, Set<BlockPos> changedBlocksTrunk, Set<BlockPos> changedBlocksFoliage, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        int treeHeight = rand.nextInt(this.baseHeightRandomRange()) + this.baseHeight();
        int worldHeight = world.getMaxHeight();
        if (blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() + treeHeight + 1 <= worldHeight) {
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            if (y < worldHeight - treeHeight - 1) {
                int yOffset;
                for (yOffset = y - 5 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    int center = 2;
                    for (int xOffset = x - center; xOffset <= x + center; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 31;
                        xPos = xPos + t ^ t;
                        for (int zOffset = z - center; zOffset <= z + center; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            BlockPos loopPos = new BlockPos(xOffset, yOffset, zOffset);
                            if (!(xPos != center | zPos != center) || (yOffset == y + treeHeight || yOffset == y - 5 + treeHeight) && (xPos == center || zPos == center)) continue;
                            this.func_227219_b_(world, rand, loopPos, changedBlocksFoliage, boundingBox, (BaseTreeFeatureConfig)config);
                        }
                    }
                }
                LinkedList logLocations = Lists.newLinkedList();
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 0)));
                    if (yOffset < 1 + treeHeight - 5 || yOffset > 1 + treeHeight - 1) continue;
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(-1, yOffset, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(1, yOffset, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, -1)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 1)));
                }
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(-1, 0, 0)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(1, 0, 0)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(0, 0, -1)));
                logLocations.add(Pair.of((Object)true, (Object)blockPos.func_177982_a(0, 0, 1)));
                for (Pair pair : logLocations) {
                    BlockPos loopPos = (BlockPos)pair.getRight();
                    BlockState logs = config.field_227368_m_.func_225574_a_(rand, loopPos);
                    logs = logs.func_177230_c() instanceof BlockMenrilLogFilled ? (BlockState)logs.func_206870_a(BlockMenrilLogFilled.SIDE, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(rand)) : logs;
                    this.func_227217_a_((IWorldWriter)world, loopPos, (BlockState)logs.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Y), boundingBox);
                }
                return true;
            }
        }
        return false;
    }
}

