/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect;

import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositioned;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.RefinedStorageInitializer;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.LazyCompositeList;

public class ValueTypeListProxyPositionedNetworkMasterItemInventory
extends ValueTypeListProxyPositioned<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>
implements INBTProvider {
    public ValueTypeListProxyPositionedNetworkMasterItemInventory() {
        this(null);
    }

    public ValueTypeListProxyPositionedNetworkMasterItemInventory(DimPos pos) {
        super(RefinedStorageInitializer.POSITIONED_MASTERITEMINVENTORY.getName(), ValueTypes.OBJECT_ITEMSTACK, pos, Direction.NORTH);
    }

    protected Optional<INetworkNode> getNetworkMaster() {
        return TileHelpers.getSafeTile((DimPos)this.getPos(), INetworkNodeProxy.class).map(INetworkNodeProxy::getNode);
    }

    protected Optional<List<ItemStack>> getInventory() {
        return this.getNetworkMaster().map(networkMaster -> {
            INetwork network = networkMaster.getNetwork();
            if (network == null) {
                return Collections.emptyList();
            }
            List itemStacksLists = network.getItemStorageCache().getStorages().stream().map(itemStorage -> {
                Collection stacks = itemStorage.getStacks();
                return stacks instanceof List ? (List)stacks : Lists.newArrayList((Iterable)stacks);
            }).collect(Collectors.toList());
            return new LazyCompositeList(itemStacksLists);
        });
    }

    @Override
    public int getLength() {
        return this.getInventory().orElse(Collections.emptyList()).size();
    }

    @Override
    public ValueObjectTypeItemStack.ValueItemStack get(int index) {
        return ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)this.getInventory().orElse(Collections.emptyList()).get(index));
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
    }
}

