/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IDynamicLightBlock;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstoneBlock;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.block.cable.ICableNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.core.block.CollidableComponent;
import org.cyclops.integrateddynamics.core.block.ICollidable;
import org.cyclops.integrateddynamics.core.block.ICollidableParent;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkFacadeableComponent;
import org.cyclops.integrateddynamics.core.block.cable.NetworkElementProviderComponent;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.path.CablePathElement;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;
import org.cyclops.integrateddynamics.item.ItemBlockCable;
import org.cyclops.integrateddynamics.item.ItemFacade;

public class BlockCable
extends ConfigurableBlockContainer
implements ICableNetwork<IPartNetwork, ICablePathElement>,
ICableFakeable<ICablePathElement>,
ICableFacadeable<ICablePathElement>,
INetworkElementProvider,
IPartContainerFacade,
ICollidable<EnumFacing>,
ICollidableParent,
IDynamicRedstoneBlock,
IDynamicLightBlock {
    public static final float BLOCK_HARDNESS = 3.0f;
    public static final Material BLOCK_MATERIAL = Material.field_151592_s;
    @BlockProperty
    public static final IUnlistedProperty<Boolean> REALCABLE = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"realcable"));
    @BlockProperty
    public static final IUnlistedProperty<Boolean>[] CONNECTED = new IUnlistedProperty[6];
    @BlockProperty
    public static final IUnlistedProperty<IPartType.RenderPosition>[] PART_RENDERPOSITIONS = new IUnlistedProperty[6];
    @BlockProperty
    public static final IUnlistedProperty<Optional> FACADE = new UnlistedProperty("facade", Optional.class);
    @BlockProperty
    public static final IUnlistedProperty<IPartContainer> PARTCONTAINER;
    public static final float[][] CABLE_COLLISION_BOXES;
    private static final List<ICollidable.IComponent<EnumFacing, BlockCable>> COLLIDABLE_COMPONENTS;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> CENTER_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> CABLECONNECTIONS_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> PARTS_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> FACADE_COMPONENT;
    private ICollidable collidableComponent = new CollidableComponent(this, COLLIDABLE_COMPONENTS);
    private CableNetworkFacadeableComponent<BlockCable> cableNetworkComponent = new CableNetworkFacadeableComponent<BlockCable>(this);
    private NetworkElementProviderComponent<IPartNetwork> networkElementProviderComponent = new NetworkElementProviderComponent(this);
    private static BlockCable _instance;
    public static boolean IS_MCMP_CONVERTING;
    @SideOnly(value=Side.CLIENT)
    @Icon(location="blocks/cable")
    public TextureAtlasSprite texture;
    private boolean disableCollisionBox = false;

    public static BlockCable getInstance() {
        return _instance;
    }

    public BlockCable(ExtendedConfig eConfig) {
        super(eConfig, BLOCK_MATERIAL, TileMultipartTicking.class);
        this.func_149711_c(3.0f);
        this.func_149672_a(field_149777_j);
        if (MinecraftHelpers.isClientSide()) {
            eConfig.getMod().getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            return tile.getConnectionState();
        }
        return this.func_176223_P();
    }

    protected boolean hasPart(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)this.getExtendedState(world.func_180495_p(pos), world, pos)), PART_RENDERPOSITIONS[side.ordinal()], (Object)IPartType.RenderPosition.NONE) != IPartType.RenderPosition.NONE;
    }

    @Override
    public boolean isRealCable(World world, BlockPos pos) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            return tile.isRealCable();
        }
        return true;
    }

    @Override
    public void setRealCable(World world, BlockPos pos, boolean realCable) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            tile.setRealCable(realCable);
            if (realCable) {
                this.cableNetworkComponent.addToNetwork(world, pos);
            } else {
                this.networkElementProviderComponent.onPreBlockDestroyed(this.getNetwork(world, pos), world, pos, false);
                if (!this.cableNetworkComponent.removeCableFromNetwork(world, pos)) {
                    tile.setRealCable(!realCable);
                    IntegratedDynamics.clog(Level.WARN, "Tried to set a fake cable, but the original network element was not present");
                }
            }
        }
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos, EntityPlayer player) {
        if (this.isRealCable(world, pos)) {
            this.networkElementProviderComponent.onPreBlockDestroyed(this.getNetwork(world, pos), world, pos, true);
            this.cableNetworkComponent.onPreBlockDestroyed(world, pos);
        }
        super.onPreBlockDestroyed(world, pos);
    }

    protected void onPostBlockDestroyed(World world, BlockPos pos) {
        super.onPostBlockDestroyed(world, pos);
        if (!IS_MCMP_CONVERTING) {
            IS_MCMP_CONVERTING = false;
            this.cableNetworkComponent.onPostBlockDestroyed(world, pos);
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null && rayTraceResult.getCollisionType() != null) {
            return rayTraceResult.getCollisionType().destroy(world, pos, rayTraceResult.getPositionHit(), player);
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ICollidable.RayTraceResult rayTraceResult;
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null && (rayTraceResult = this.doRayTrace(world, pos, player)) != null) {
            EnumFacing positionHit = (EnumFacing)rayTraceResult.getPositionHit();
            if (rayTraceResult.getCollisionType() == FACADE_COMPONENT) {
                if (!world.field_72995_K && WrenchHelpers.isWrench(player, pos) && player.func_70093_af()) {
                    FACADE_COMPONENT.destroy(world, pos, side, player);
                    world.func_175685_c(pos, (Block)this);
                    return true;
                }
                return false;
            }
            if (rayTraceResult.getCollisionType() == PARTS_COMPONENT) {
                if (!world.field_72995_K && WrenchHelpers.isWrench(player, pos)) {
                    if (player.func_70093_af()) {
                        PARTS_COMPONENT.destroy(world, pos, (EnumFacing)rayTraceResult.getPositionHit(), player);
                        ItemBlockCable.playBreakSound(world, pos, BlockCable.getInstance().func_176223_P());
                    }
                    return true;
                }
                if (this.isRealCable(world, pos)) {
                    return this.getPartContainer((IBlockAccess)world, pos).getPart(positionHit).onPartActivated(world, pos, this.getPartContainer((IBlockAccess)world, pos).getPartState(positionHit), player, positionHit, hitX, hitY, hitZ);
                }
            } else if (!world.field_72995_K && (rayTraceResult.getCollisionType() == CABLECONNECTIONS_COMPONENT || rayTraceResult.getCollisionType() == CENTER_COMPONENT) && BlockCable.onCableActivated(world, pos, state, player, side, rayTraceResult.getCollisionType() == CENTER_COMPONENT ? null : (EnumFacing)rayTraceResult.getPositionHit())) {
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public static boolean onCableActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, EnumFacing cableConnectionHit) {
        ICableNetwork cable = CableHelpers.getInterface((IBlockAccess)world, pos, ICableNetwork.class);
        if (WrenchHelpers.isWrench(player, pos)) {
            if (player.func_70093_af()) {
                if (!(cable instanceof IPartContainerFacade && ((IPartContainerFacade)((Object)cable)).getPartContainer((IBlockAccess)world, pos).hasParts() && cable instanceof ICableFakeable)) {
                    cable.remove(world, pos, player);
                    ItemBlockCable.playBreakSound(world, pos, state);
                } else {
                    ((ICableFakeable)((Object)cable)).setRealCable(world, pos, false);
                    ItemBlockCable.playBreakSound(world, pos, state);
                    ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)BlockCable.getInstance()), (EntityPlayer)player);
                }
            } else {
                if (cableConnectionHit != null) {
                    cable.disconnect(world, pos, cableConnectionHit);
                    cable.updateConnections(world, pos);
                    cable.triggerUpdateNeighbourConnections(world, pos);
                    cable.initNetwork(world, pos);
                    BlockPos neighbourPos = pos.func_177972_a(cableConnectionHit);
                    ICableNetwork neighbourCable = CableHelpers.getInterface((IBlockAccess)world, neighbourPos, ICableNetwork.class);
                    if (neighbourCable != null) {
                        neighbourCable.initNetwork(world, neighbourPos);
                    }
                    return true;
                }
                if (cableConnectionHit == null) {
                    BlockPos neighbourPos = pos.func_177972_a(side);
                    ICable neighbourCable = CableHelpers.getInterface((IBlockAccess)world, neighbourPos, ICable.class);
                    if (neighbourCable != null && !cable.isConnected(world, pos, side) && (cable.canConnect(world, pos, neighbourCable, side) || neighbourCable.canConnect(world, neighbourPos, cable, side.func_176734_d()))) {
                        cable.reconnect(world, pos, side);
                        neighbourCable.reconnect(world, neighbourPos, side.func_176734_d());
                        cable.updateConnections(world, pos);
                        cable.triggerUpdateNeighbourConnections(world, pos);
                        cable.initNetwork(world, pos);
                        if (neighbourCable instanceof ICableNetwork) {
                            ((ICableNetwork)neighbourCable).initNetwork(world, neighbourPos);
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        this.cableNetworkComponent.addToNetwork(world, pos);
    }

    public boolean saveNBTToDroppedItem() {
        return false;
    }

    public boolean isDropBlockItem(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)this.getExtendedState(blockState, world, pos)), REALCABLE, (Object)true);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null) {
            EnumFacing positionHit = (EnumFacing)rayTraceResult.getPositionHit();
            return rayTraceResult.getCollisionType().getPickBlock(world, pos, positionHit);
        }
        return new ItemStack(this.func_180665_b(world, pos), 1, this.func_176222_j(world, pos));
    }

    public Collection<INetworkElement> createNetworkElements(World world, BlockPos blockPos) {
        HashSet sidedElements = Sets.newHashSet();
        for (Map.Entry<EnumFacing, IPartType<?, ?>> entry : this.getPartContainer((IBlockAccess)world, blockPos).getParts().entrySet()) {
            sidedElements.add(entry.getValue().createNetworkElement(this, DimPos.of((World)world, (BlockPos)blockPos), entry.getKey()));
        }
        return sidedElements;
    }

    @Override
    public IPartContainer getPartContainer(IBlockAccess world, BlockPos pos) {
        return (IPartContainer)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, IPartContainer.class);
    }

    @Override
    @Nullable
    public EnumFacing getWatchingSide(World world, BlockPos pos, EntityPlayer player) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null) {
            return (EnumFacing)rayTraceResult.getPositionHit();
        }
        return null;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.disableCollisionBox) {
            return null;
        }
        return super.func_180640_a(worldIn, pos, state);
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.hasFacade(world, pos) ? 255 : 0;
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new CableModel();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.doesSideBlockRendering(world, pos, face) || this.hasFacade(world, pos);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos blockPos = target.func_178782_a();
        if (this.hasFacade((IBlockAccess)world, blockPos)) {
            IBlockState blockState = this.getFacade(world, blockPos);
            RenderHelpers.addBlockHitEffects((EffectRenderer)effectRenderer, (World)world, (IBlockState)blockState, (BlockPos)blockPos, (EnumFacing)target.field_178784_b);
            return true;
        }
        return super.addHitEffects(world, target, effectRenderer);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.hasFacade(world, pos)) {
            return true;
        }
        if (this.hasPart(world, pos, side)) {
            IPartContainer partContainer = this.getPartContainer(world, pos);
            IPartType partType = partContainer.getPart(side);
            return partType.isSolid(partContainer.getPartState(side));
        }
        return super.isSideSolid(world, pos, side);
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public AxisAlignedBB getCableBoundingBox(EnumFacing side) {
        float min = 0.375f;
        float max = 0.625f;
        if (side == null) {
            return AxisAlignedBB.func_178781_a((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        float[] b = CABLE_COLLISION_BOXES[side.ordinal()];
        return AxisAlignedBB.func_178781_a((double)b[0], (double)b[1], (double)b[2], (double)b[3], (double)b[4], (double)b[5]);
    }

    protected IPartType.RenderPosition getPartRenderPosition(World world, BlockPos pos, EnumFacing side) {
        return (IPartType.RenderPosition)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)this.getExtendedState(world.func_180495_p(pos), (IBlockAccess)world, pos)), PART_RENDERPOSITIONS[side.ordinal()], (Object)IPartType.RenderPosition.NONE);
    }

    private AxisAlignedBB getCableBoundingBoxWithPart(World world, BlockPos pos, EnumFacing side) {
        float min = 0.375f;
        float max = 0.625f;
        if (side == null) {
            return AxisAlignedBB.func_178781_a((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        return this.getPartRenderPosition(world, pos, side).getSidedCableBoundingBox(side);
    }

    private AxisAlignedBB getPartBoundingBox(World world, BlockPos pos, EnumFacing side) {
        return this.getPartRenderPosition(world, pos, side).getBoundingBox(side);
    }

    @Override
    public void addCollisionBoxesToListParent(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxParent(World worldIn, BlockPos pos) {
        return super.func_180646_a(worldIn, pos);
    }

    @Override
    public MovingObjectPosition collisionRayTraceParent(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        return super.func_180636_a(world, pos, origin, direction);
    }

    @Override
    public void disableRedstoneAt(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            tile.disableRedstoneLevel(side);
        }
    }

    @Override
    public void setRedstoneLevel(IBlockAccess world, BlockPos pos, EnumFacing side, int level) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            tile.setRedstoneLevel(side, level);
        }
    }

    @Override
    public int getRedstoneLevel(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            return tile.getRedstoneLevel(side);
        }
        return -1;
    }

    @Override
    public void setAllowRedstoneInput(IBlockAccess world, BlockPos pos, EnumFacing side, boolean allow) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            tile.setAllowRedstoneInput(side, allow);
        }
    }

    @Override
    public boolean isAllowRedstoneInput(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            return tile.isAllowRedstoneInput(side);
        }
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            for (EnumFacing dummySide : EnumFacing.field_82609_l) {
                if (this.getRedstoneLevel(world, pos, dummySide) < 0 && !this.isAllowRedstoneInput(world, pos, dummySide)) continue;
                return true;
            }
            return false;
        }
        return this.getRedstoneLevel(world, pos, side.func_176734_d()) >= 0 || this.isAllowRedstoneInput(world, pos, side.func_176734_d());
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return 0;
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.getRedstoneLevel(world, pos, side.func_176734_d());
    }

    @Override
    public void setLightLevel(IBlockAccess world, BlockPos pos, EnumFacing side, int level) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            tile.setLightLevel(side, level);
        }
    }

    @Override
    public int getLightLevel(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null) {
            return tile.getLightLevel(side);
        }
        return 0;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        int light = 0;
        for (EnumFacing side : EnumFacing.values()) {
            light = Math.max(light, this.getLightLevel(world, pos, side));
        }
        return light;
    }

    @Override
    public void initNetwork(World world, BlockPos pos) {
        if (this.isRealCable(world, pos)) {
            this.cableNetworkComponent.initNetwork(world, pos);
        }
    }

    @Override
    public boolean canConnect(World world, BlockPos selfPosition, ICable connector, EnumFacing side) {
        return this.cableNetworkComponent.canConnect(world, selfPosition, connector, side);
    }

    @Override
    public void updateConnections(World world, BlockPos pos) {
        this.cableNetworkComponent.updateConnections(world, pos);
    }

    @Override
    public void triggerUpdateNeighbourConnections(World world, BlockPos pos) {
        this.cableNetworkComponent.triggerUpdateNeighbourConnections(world, pos);
    }

    @Override
    public boolean isConnected(World world, BlockPos pos, EnumFacing side) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)this.getExtendedState(world.func_180495_p(pos), (IBlockAccess)world, pos)), CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    public void disconnect(World world, BlockPos pos, EnumFacing side) {
        this.cableNetworkComponent.disconnect(world, pos, side);
    }

    @Override
    public void reconnect(World world, BlockPos pos, EnumFacing side) {
        this.cableNetworkComponent.reconnect(world, pos, side);
    }

    @Override
    public void remove(World world, BlockPos pos, EntityPlayer player) {
        this.networkElementProviderComponent.onPreBlockDestroyed(this.getNetwork(world, pos), world, pos, true);
        this.cableNetworkComponent.onPreBlockDestroyed(world, pos);
        this.cableNetworkComponent.remove(world, pos, player);
    }

    @Override
    public boolean hasFacade(IBlockAccess world, BlockPos pos) {
        return this.cableNetworkComponent.hasFacade(world, pos);
    }

    @Override
    public IBlockState getFacade(World world, BlockPos pos) {
        return this.cableNetworkComponent.getFacade(world, pos);
    }

    @Override
    public void setFacade(World world, BlockPos pos, @Nullable IBlockState blockState) {
        this.cableNetworkComponent.setFacade(world, pos, blockState);
    }

    @Override
    public void resetCurrentNetwork(World world, BlockPos pos) {
        this.cableNetworkComponent.resetCurrentNetwork(world, pos);
    }

    @Override
    public void setNetwork(IPartNetwork network, World world, BlockPos pos) {
        this.cableNetworkComponent.setNetwork(network, world, pos);
    }

    @Override
    public IPartNetwork getNetwork(World world, BlockPos pos) {
        return this.cableNetworkComponent.getNetwork(world, pos);
    }

    @Override
    public CablePathElement createPathElement(World world, BlockPos blockPos) {
        return this.cableNetworkComponent.createPathElement(world, blockPos);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(world, pos, state, neighborBlock);
        this.cableNetworkComponent.updateConnections(world, pos);
        this.networkElementProviderComponent.onBlockNeighborChange(this.getNetwork(world, pos), world, pos, neighborBlock);
    }

    public void setDisableCollisionBox(boolean disableCollisionBox) {
        this.disableCollisionBox = disableCollisionBox;
    }

    @Override
    public Block getBlock() {
        return this.collidableComponent.getBlock();
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.collidableComponent.addCollisionBoxesToList(world, pos, state, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return this.collidableComponent.getSelectedBoundingBox(worldIn, pos);
    }

    @Override
    public ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        return this.collidableComponent.doRayTrace(world, pos, player);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        return this.collidableComponent.collisionRayTrace(world, pos, origin, direction);
    }

    static {
        for (EnumFacing side : EnumFacing.values()) {
            BlockCable.CONNECTED[side.ordinal()] = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)("connect-" + side.func_176610_l())));
            BlockCable.PART_RENDERPOSITIONS[side.ordinal()] = new UnlistedProperty("partRenderPosition-" + side.func_176610_l(), IPartType.RenderPosition.class);
        }
        PARTCONTAINER = new UnlistedProperty("partcontainer", IPartContainer.class);
        CABLE_COLLISION_BOXES = new float[][]{{0.375f, 0.0f, 0.375f, 0.625f, 0.375f, 0.625f}, {0.375f, 0.625f, 0.375f, 0.625f, 1.0f, 0.625f}, {0.375f, 0.375f, 0.0f, 0.625f, 0.625f, 0.375f}, {0.375f, 0.625f, 0.625f, 0.625f, 0.375f, 1.0f}, {0.0f, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f}, {0.625f, 0.375f, 0.375f, 1.0f, 0.625f, 0.625f}};
        COLLIDABLE_COMPONENTS = Lists.newLinkedList();
        CENTER_COMPONENT = new ICollidable.IComponent<EnumFacing, BlockCable>(){

            @Override
            public Collection<EnumFacing> getPossiblePositions() {
                return Arrays.asList(new EnumFacing[]{null});
            }

            @Override
            public int getBoundsCount(EnumFacing position) {
                return 1;
            }

            @Override
            public boolean isActive(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return block.isRealCable(world, pos);
            }

            @Override
            public List<AxisAlignedBB> getBounds(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return Collections.singletonList(block.getCableBoundingBox(null));
            }

            @Override
            public ItemStack getPickBlock(World world, BlockPos pos, EnumFacing position) {
                return new ItemStack((Block)BlockCable.getInstance());
            }

            @Override
            public boolean destroy(World world, BlockPos pos, EnumFacing position, EntityPlayer player) {
                if (!world.field_72995_K) {
                    BlockCable cable = BlockCable.getInstance();
                    if (cable.getPartContainer((IBlockAccess)world, pos).hasParts()) {
                        cable.setRealCable(world, pos, false);
                        ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)BlockCable.getInstance()), (EntityPlayer)player);
                        return false;
                    }
                    cable.remove(world, pos, player);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            @SideOnly(value=Side.CLIENT)
            public IBakedModel getBreakingBaseModel(World world, BlockPos pos, EnumFacing position) {
                return RenderHelpers.getDynamicBakedModel((World)world, (BlockPos)pos);
            }
        };
        CABLECONNECTIONS_COMPONENT = new ICollidable.IComponent<EnumFacing, BlockCable>(){

            @Override
            public Collection<EnumFacing> getPossiblePositions() {
                return Arrays.asList(EnumFacing.field_82609_l);
            }

            @Override
            public int getBoundsCount(EnumFacing position) {
                return 1;
            }

            @Override
            public boolean isActive(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return CENTER_COMPONENT.isActive(block, world, pos, position) && (block.isConnected(world, pos, position) || block.hasPart((IBlockAccess)world, pos, position));
            }

            @Override
            public List<AxisAlignedBB> getBounds(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return Collections.singletonList(block.isConnected(world, pos, position) ? block.getCableBoundingBox(position) : block.getCableBoundingBoxWithPart(world, pos, position));
            }

            @Override
            public ItemStack getPickBlock(World world, BlockPos pos, EnumFacing position) {
                return new ItemStack((Block)BlockCable.getInstance());
            }

            @Override
            public boolean destroy(World world, BlockPos pos, EnumFacing position, EntityPlayer player) {
                return CENTER_COMPONENT.destroy(world, pos, position, player);
            }

            @Override
            @Nullable
            @SideOnly(value=Side.CLIENT)
            public IBakedModel getBreakingBaseModel(World world, BlockPos pos, EnumFacing position) {
                return CENTER_COMPONENT.getBreakingBaseModel(world, pos, position);
            }
        };
        PARTS_COMPONENT = new ICollidable.IComponent<EnumFacing, BlockCable>(){

            @Override
            public Collection<EnumFacing> getPossiblePositions() {
                return Arrays.asList(EnumFacing.field_82609_l);
            }

            @Override
            public int getBoundsCount(EnumFacing position) {
                return 1;
            }

            @Override
            public boolean isActive(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return block.hasPart((IBlockAccess)world, pos, position);
            }

            @Override
            public List<AxisAlignedBB> getBounds(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return Collections.singletonList(block.getPartBoundingBox(world, pos, position));
            }

            @Override
            public ItemStack getPickBlock(World world, BlockPos pos, EnumFacing position) {
                IPartContainer partContainer = BlockCable.getInstance().getPartContainer((IBlockAccess)world, pos);
                return partContainer.getPart(position).getPickBlock(world, pos, partContainer.getPartState(position));
            }

            @Override
            public boolean destroy(World world, BlockPos pos, EnumFacing position, EntityPlayer player) {
                if (!world.field_72995_K) {
                    return PartHelpers.removePart(world, pos, position, player, true);
                }
                return false;
            }

            @Override
            @Nullable
            @SideOnly(value=Side.CLIENT)
            public IBakedModel getBreakingBaseModel(World world, BlockPos pos, EnumFacing position) {
                IBlockState blockState = world.func_180495_p(pos);
                IExtendedBlockState state = (IExtendedBlockState)blockState.func_177230_c().getExtendedState(blockState, (IBlockAccess)world, pos);
                IPartContainer partContainer = (IPartContainer)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)state, PARTCONTAINER, null);
                IBlockState cableState = partContainer != null ? partContainer.getPart(position).getBlockState(partContainer, position) : null;
                return RenderHelpers.getBakedModel(cableState);
            }
        };
        FACADE_COMPONENT = new ICollidable.IComponent<EnumFacing, BlockCable>(){
            private final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);

            @Override
            public Collection<EnumFacing> getPossiblePositions() {
                return Arrays.asList(new EnumFacing[]{null});
            }

            @Override
            public int getBoundsCount(EnumFacing position) {
                return 1;
            }

            @Override
            public boolean isActive(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return block.hasFacade((IBlockAccess)world, pos);
            }

            @Override
            public List<AxisAlignedBB> getBounds(BlockCable block, World world, BlockPos pos, EnumFacing position) {
                return Collections.singletonList(this.BOUNDS);
            }

            @Override
            public ItemStack getPickBlock(World world, BlockPos pos, EnumFacing position) {
                ItemStack itemStack = new ItemStack((Item)ItemFacade.getInstance());
                ItemFacade.getInstance().writeFacadeBlock(itemStack, BlockCable.getInstance().getFacade(world, pos));
                return itemStack;
            }

            @Override
            public boolean destroy(World world, BlockPos pos, EnumFacing position, EntityPlayer player) {
                if (!world.field_72995_K) {
                    IBlockState blockState = BlockCable.getInstance().getFacade(world, pos);
                    ItemStack itemStack = new ItemStack((Item)ItemFacade.getInstance());
                    ItemFacade.getInstance().writeFacadeBlock(itemStack, blockState);
                    BlockCable.getInstance().setFacade(world, pos, null);
                    ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)itemStack, (EntityPlayer)player);
                }
                return false;
            }

            @Override
            @Nullable
            @SideOnly(value=Side.CLIENT)
            public IBakedModel getBreakingBaseModel(World world, BlockPos pos, EnumFacing position) {
                IBlockState blockState = world.func_180495_p(pos);
                IExtendedBlockState state = (IExtendedBlockState)blockState.func_177230_c().getExtendedState(blockState, (IBlockAccess)world, pos);
                Optional blockStateOptional = (Optional)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)state, FACADE, (Object)Optional.absent());
                if (!blockStateOptional.isPresent()) {
                    return null;
                }
                return RenderHelpers.getBakedModel((IBlockState)((IBlockState)blockStateOptional.get()));
            }
        };
        COLLIDABLE_COMPONENTS.add(FACADE_COMPONENT);
        COLLIDABLE_COMPONENTS.add(CENTER_COMPONENT);
        COLLIDABLE_COMPONENTS.add(CABLECONNECTIONS_COMPONENT);
        COLLIDABLE_COMPONENTS.add(PARTS_COMPONENT);
        _instance = null;
        IS_MCMP_CONVERTING = false;
    }
}

