/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.client.gui.GuiCoalGenerator;
import org.cyclops.integrateddynamics.core.block.BlockContainerGuiCabled;
import org.cyclops.integrateddynamics.inventory.container.ContainerCoalGenerator;
import org.cyclops.integrateddynamics.network.CoalGeneratorNetworkElement;
import org.cyclops.integrateddynamics.tileentity.TileCoalGenerator;

public class BlockCoalGenerator
extends BlockContainerGuiCabled {
    @BlockProperty
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    @BlockProperty
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    private static BlockCoalGenerator _instance = null;

    public static BlockCoalGenerator getInstance() {
        return _instance;
    }

    public BlockCoalGenerator(ExtendedConfig eConfig) {
        super(eConfig, TileCoalGenerator.class);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        ((TileCoalGenerator)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileCoalGenerator.class)).updateBlockState();
    }

    @Override
    public Collection<INetworkElement<IPartNetwork>> createNetworkElements(World world, BlockPos blockPos) {
        return Sets.newHashSet((Object[])new INetworkElement[]{new CoalGeneratorNetworkElement(DimPos.of((World)world, (BlockPos)blockPos))});
    }

    public Class<? extends Container> getContainer() {
        return ContainerCoalGenerator.class;
    }

    public Class<? extends GuiScreen> getGui() {
        return GuiCoalGenerator.class;
    }
}

