/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.tileentity.TileDryingBasin;

public class BlockDryingBasin
extends ConfigurableBlockContainer
implements IMachine<BlockDryingBasin, ItemAndFluidStackRecipeComponent, ItemAndFluidStackRecipeComponent, DurationRecipeProperties> {
    private static BlockDryingBasin _instance = null;

    public static BlockDryingBasin getInstance() {
        return _instance;
    }

    public BlockDryingBasin(ExtendedConfig eConfig) {
        super(eConfig, Material.field_151575_d, TileDryingBasin.class);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumFacing side, float motionX, float motionY, float motionZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        TileDryingBasin tile = (TileDryingBasin)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileDryingBasin.class));
        if (tile != null) {
            ItemStack tileStack = tile.func_70301_a(0);
            if ((itemStack == null || ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)tileStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)tileStack) && itemStack.field_77994_a < itemStack.func_77976_d()) && tileStack != null) {
                if (itemStack != null) {
                    tileStack.field_77994_a += itemStack.field_77994_a;
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                tile.func_70299_a(0, null);
                tile.sendUpdate();
                return true;
            }
            if (itemStack != null && !tile.getTank().isFull() && FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                if (tile.canFill(EnumFacing.UP, fluidStack.getFluid()) && tile.getTank().canCompletelyFill(fluidStack)) {
                    tile.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack), true);
                    ItemStack newItemStack = FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack);
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                    tile.sendUpdate();
                    return true;
                }
            } else if (itemStack != null && !tile.getTank().isEmpty() && FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack newItemStack;
                if (FluidContainerRegistry.isContainer((ItemStack)itemStack) && (newItemStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tile.getTank().getFluid(), (ItemStack)itemStack)) != null) {
                    tile.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)newItemStack), true);
                    InventoryHelpers.tryReAddToStack((EntityPlayer)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                    return true;
                }
            } else if (itemStack != null && tileStack == null) {
                tile.func_70299_a(0, itemStack.func_77979_a(1));
                if (itemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                tile.sendUpdate();
                return true;
            }
        }
        return false;
    }

    public void func_180638_a(World world, BlockPos blockPos, IBlockState blockState, AxisAlignedBB area, List<AxisAlignedBB> collisionBoxes, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos blockPos) {
        TileDryingBasin tile = (TileDryingBasin)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileDryingBasin.class));
        if (tile == null) {
            return 0;
        }
        return tile.getInventory().func_70301_a(0) != null ? 15 : 0;
    }

    public IRecipeRegistry<BlockDryingBasin, ItemAndFluidStackRecipeComponent, ItemAndFluidStackRecipeComponent, DurationRecipeProperties> getRecipeRegistry() {
        return ((ISuperRecipeRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(ISuperRecipeRegistry.class)).getRecipeRegistry((IMachine)this);
    }
}

