/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IEnergyBattery;
import org.cyclops.integrateddynamics.api.block.IEnergyBatteryFacade;
import org.cyclops.integrateddynamics.api.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.block.BlockContainerCabled;
import org.cyclops.integrateddynamics.network.EnergyBatteryNetworkElement;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public abstract class BlockEnergyBatteryBase
extends BlockContainerCabled
implements IEnergyBatteryFacade,
IEnergyContainerBlock {
    @BlockProperty
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockEnergyBatteryBase(ExtendedConfig eConfig) {
        super(eConfig, TileEnergyBattery.class);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        ((TileEnergyBattery)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileEnergyBattery.class)).updateBlockState();
    }

    @Override
    public Collection<INetworkElement<IPartNetwork>> createNetworkElements(World world, BlockPos blockPos) {
        return Sets.newHashSet((Object[])new INetworkElement[]{new EnergyBatteryNetworkElement(DimPos.of((World)world, (BlockPos)blockPos))});
    }

    @Override
    public IEnergyBattery getEnergyBattery(World world, BlockPos pos) {
        return (IEnergyBattery)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileEnergyBattery.class);
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    @Override
    public String getEneryContainerNBTName() {
        return "energy";
    }

    public abstract boolean isCreative();
}

