/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.client.gui.GuiProxy;
import org.cyclops.integrateddynamics.core.block.BlockContainerGuiCabled;
import org.cyclops.integrateddynamics.inventory.container.ContainerProxy;
import org.cyclops.integrateddynamics.network.ProxyNetworkElement;
import org.cyclops.integrateddynamics.tileentity.TileProxy;

public class BlockProxy
extends BlockContainerGuiCabled {
    @BlockProperty
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static BlockProxy _instance = null;

    public static BlockProxy getInstance() {
        return _instance;
    }

    public BlockProxy(ExtendedConfig eConfig) {
        super(eConfig, TileProxy.class);
    }

    @Override
    public Collection<INetworkElement<IPartNetwork>> createNetworkElements(World world, BlockPos blockPos) {
        return Sets.newHashSet((Object[])new INetworkElement[]{new ProxyNetworkElement(DimPos.of((World)world, (BlockPos)blockPos))});
    }

    @Override
    protected void onPreBlockDestroyed(World world, BlockPos pos) {
        TileProxy tile = (TileProxy)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileProxy.class);
        tile.updateConnections();
        super.onPreBlockDestroyed(world, pos);
    }

    public Class<? extends Container> getContainer() {
        return ContainerProxy.class;
    }

    public Class<? extends GuiScreen> getGui() {
        return GuiProxy.class;
    }
}

