/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.tileentity.TileSqueezer;

public class BlockSqueezer
extends ConfigurableBlockContainer
implements IMachine<BlockSqueezer, ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> {
    @BlockProperty
    public static final PropertyEnum<EnumAxis> AXIS = PropertyDirection.func_177709_a((String)"axis", EnumAxis.class);
    @BlockProperty
    public static final PropertyInteger HEIGHT = PropertyInteger.func_177719_a((String)"height", (int)1, (int)7);
    private static BlockSqueezer _instance = null;

    public static BlockSqueezer getInstance() {
        return _instance;
    }

    public BlockSqueezer(ExtendedConfig eConfig) {
        super(eConfig, Material.field_151573_f, TileSqueezer.class);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumFacing side, float motionX, float motionY, float motionZ) {
        if (world.field_72995_K) {
            return true;
        }
        if ((Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)HEIGHT) == 1) {
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            TileSqueezer tile = (TileSqueezer)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileSqueezer.class));
            if (tile != null) {
                ItemStack tileStack = tile.func_70301_a(0);
                if ((itemStack == null || ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)tileStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)tileStack) && tileStack.field_77994_a < tileStack.func_77976_d()) && tileStack != null) {
                    if (itemStack != null) {
                        tileStack.field_77994_a += itemStack.field_77994_a;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                    tile.func_70299_a(0, null);
                    tile.sendUpdate();
                    return true;
                }
                if (itemStack != null && tile.func_70301_a(0) == null) {
                    tile.func_70299_a(0, itemStack.func_77979_a(1));
                    if (itemStack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    tile.sendUpdate();
                    return true;
                }
            }
        }
        return false;
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        double motionY = entityIn.field_70181_x;
        super.func_176216_a(worldIn, entityIn);
        if (!worldIn.field_72995_K && motionY <= -0.37 && entityIn instanceof EntityLivingBase) {
            int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int j = MathHelper.func_76128_c((double)(entityIn.field_70163_u - 0.2));
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            BlockPos blockPos = new BlockPos(i, j, k);
            IBlockState blockState = worldIn.func_180495_p(blockPos);
            int steps = 1 + MathHelper.func_76128_c((double)((-motionY - 0.37) * 5.0));
            if (entityIn.field_70163_u - (double)blockPos.func_177956_o() - (double)this.getRelativeTopPositionTop((IBlockAccess)worldIn, blockPos, blockState) <= (double)0.1f && blockState.func_177230_c() == this) {
                int newHeight = Math.min(7, (Integer)blockState.func_177229_b((IProperty)HEIGHT) + steps);
                worldIn.func_175656_a(blockPos, blockState.func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(newHeight)));
                TileSqueezer tile = (TileSqueezer)((Object)TileHelpers.getSafeTile((IBlockAccess)worldIn, (BlockPos)blockPos, TileSqueezer.class));
                tile.setItemHeight(Math.max(newHeight, tile.getItemHeight()));
            }
        }
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (!worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(1)));
                for (Entity entity : worldIn.func_72872_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))) {
                    entity.field_70181_x += 0.25;
                    entity.field_70163_u += 0.5;
                }
                return;
            }
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing.Axis axis = placer.func_174811_aO().func_176740_k();
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(axis)));
    }

    public float getRelativeTopPositionTop(IBlockAccess world, BlockPos blockPos, IBlockState blockState) {
        return (float)(9 - (Integer)blockState.func_177229_b((IProperty)HEIGHT)) * 0.125f;
    }

    public void func_180638_a(World world, BlockPos blockPos, IBlockState blockState, AxisAlignedBB area, List<AxisAlignedBB> collisionBoxes, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(1.0f, 0.0f, 0.0f, 1.0f - f, 1.0f, f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(0.0f, 0.0f, 1.0f, f, 1.0f, 1.0f - f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_149676_a(1.0f, 0.0f, 1.0f, 1.0f - f, 1.0f, 1.0f - f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        float offset = (float)(8 - (Integer)blockState.func_177229_b((IProperty)HEIGHT)) * 0.125f;
        this.func_149676_a(0.0f, offset - 0.125f, 0.0f, 1.0f, offset, 1.0f);
        super.func_180638_a(world, blockPos, blockState, area, collisionBoxes, entity);
        this.func_180654_a((IBlockAccess)world, blockPos);
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, this.getRelativeTopPositionTop(worldIn, pos, state), 1.0f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        return (int)(((double)((Integer)blockState.func_177229_b((IProperty)HEIGHT)).intValue() - 1.0) / 6.0 * 15.0);
    }

    public IRecipeRegistry<BlockSqueezer, ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> getRecipeRegistry() {
        return ((ISuperRecipeRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(ISuperRecipeRegistry.class)).getRecipeRegistry((IMachine)this);
    }

    public static enum EnumAxis implements IStringSerializable
    {
        X("x", new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST}),
        Z("z", new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH});

        private final String name;
        private final EnumFacing[] sides;

        private EnumAxis(String name, EnumFacing[] sides) {
            this.name = name;
            this.sides = sides;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return Z;
                }
                case Z: {
                    return X;
                }
            }
            return X;
        }

        public String func_176610_l() {
            return this.name;
        }

        public EnumFacing[] getSides() {
            return this.sides;
        }
    }
}

