/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.ScrollingGuiContainer;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammerConfig;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeGuiElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;
import org.cyclops.integrateddynamics.item.ItemLabeller;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerActivateElementPacket;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerLabelPacket;
import org.lwjgl.input.Keyboard;

public class GuiLogicProgrammer
extends ScrollingGuiContainer {
    public static final int BOX_HEIGHT = 18;
    private static final Rectangle ITEM_POSITION = new Rectangle(19, 18, 56, 17);
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    private final boolean hasLabeller;
    protected SubGuiConfigRenderPattern operatorConfigPattern = null;

    public GuiLogicProgrammer(InventoryPlayer inventoryPlayer) {
        super((ScrollingInventoryContainer)new ContainerLogicProgrammer(inventoryPlayer));
        ContainerLogicProgrammer container = (ContainerLogicProgrammer)this.getContainer();
        container.setGui(this);
        this.hasLabeller = inventoryPlayer.func_70431_c(new ItemStack((Item)ItemLabeller.getInstance()));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.subGuiHolder.initGui(this.field_147003_i, this.field_147009_r);
    }

    protected int getScrollX() {
        return 5;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 178;
    }

    protected int getBaseXSize() {
        return 256;
    }

    protected int getBaseYSize() {
        return 240;
    }

    protected int getSearchX() {
        return 6;
    }

    protected int getSearchWidth() {
        return 70;
    }

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + BlockLogicProgrammerConfig._instance.getNamedId() + ".png";
    }

    protected float colorSmoothener(float color, boolean hover) {
        return 1.0f - (1.0f - color) / (hover ? 2.0f : 4.0f);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, partialTicks, mouseX, mouseY);
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.logicprogrammer.filter"), this.field_147003_i + this.offsetX + 5, this.field_147009_r + this.offsetY + 208, Helpers.RGBToInt((int)80, (int)80, (int)80));
        ContainerLogicProgrammer container = (ContainerLogicProgrammer)this.getScrollingInventoryContainer();
        int boxHeight = 18;
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            GlStateManager.func_179118_c();
            Triple rgb = Helpers.intToRGB((int)element.getColor());
            boolean hover = LogicProgrammerElementTypes.areEqual(container.getActiveElement(), element) || this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY));
            GlStateManager.func_179131_c((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue(), hover), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue(), hover), (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(this.field_147003_i + this.offsetX + GuiLogicProgrammer.ITEM_POSITION.x, this.field_147009_r + this.offsetY + GuiLogicProgrammer.ITEM_POSITION.y + boxHeight * i, 19, 18, GuiLogicProgrammer.ITEM_POSITION.width, GuiLogicProgrammer.ITEM_POSITION.height);
            GlStateManager.func_179141_d();
            if (hover) {
                this.func_73729_b(this.field_147003_i + this.offsetX + GuiLogicProgrammer.ITEM_POSITION.x, this.field_147009_r + this.offsetY + GuiLogicProgrammer.ITEM_POSITION.y + boxHeight * i, 0, 240, 3, 16);
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            String aspectName = L10NHelpers.localize((String)element.getSymbol());
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)aspectName, (int)(this.field_147003_i + this.offsetX + (hover ? 22 : 21)), (int)(this.field_147009_r + this.offsetY + 26 + boxHeight * i), (int)53, (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
        }
    }

    protected Rectangle getElementPosition(ContainerLogicProgrammer container, int i, boolean absolute) {
        return new Rectangle(GuiLogicProgrammer.ITEM_POSITION.x + this.offsetX + (absolute ? this.field_147003_i : 0), GuiLogicProgrammer.ITEM_POSITION.y + 18 * i + this.offsetY + (absolute ? this.field_147009_r : 0), GuiLogicProgrammer.ITEM_POSITION.width, GuiLogicProgrammer.ITEM_POSITION.height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerForegroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, mouseX, mouseY);
        ContainerLogicProgrammer container = (ContainerLogicProgrammer)this.getScrollingInventoryContainer();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            LinkedList lines = Lists.newLinkedList();
            element.loadTooltip(lines);
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void onActivateElement(ILogicProgrammerElement<SubGuiConfigRenderPattern, GuiLogicProgrammer, ContainerLogicProgrammer> element) {
        this.operatorConfigPattern = (SubGuiConfigRenderPattern)element.createSubGui(88, 18, 160, 87, this, (ContainerLogicProgrammer)this.getContainer());
        this.subGuiHolder.addSubGui(this.operatorConfigPattern);
        this.operatorConfigPattern.initGui(this.field_147003_i, this.field_147009_r);
        SubGuiOperatorInfo operatorInfoPattern = new SubGuiOperatorInfo(element);
        this.subGuiHolder.addSubGui(operatorInfoPattern);
        operatorInfoPattern.initGui(this.field_147003_i, this.field_147009_r);
    }

    protected void onDeactivateElement(ILogicProgrammerElement element) {
        this.subGuiHolder.clear();
    }

    public void handleElementActivation(ILogicProgrammerElement element) {
        ContainerLogicProgrammer container = (ContainerLogicProgrammer)this.getScrollingInventoryContainer();
        ILogicProgrammerElement newActive = null;
        this.onDeactivateElement(element);
        if (container.getActiveElement() != element) {
            newActive = element;
            if (element != null) {
                this.onActivateElement(element);
            }
        }
        container.setActiveElement(newActive, this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getX(), this.operatorConfigPattern == null ? 0 : this.operatorConfigPattern.getY());
        if (newActive != null) {
            ILogicProgrammerElementType type = newActive.getType();
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket(type.getName(), type.getName(newActive)));
        } else {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerActivateElementPacket("", ""));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.subGuiHolder.keyTyped(this.func_146983_a(keyCode), typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        ContainerLogicProgrammer container = (ContainerLogicProgrammer)this.getScrollingInventoryContainer();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            ILogicProgrammerElement element = (ILogicProgrammerElement)container.getVisibleElement(i);
            if (!this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) continue;
            this.handleElementActivation(element);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void label(String label) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerLabelPacket(label));
    }

    protected boolean hasLabeller() {
        return this.hasLabeller;
    }

    public class SubGuiOperatorInfo
    extends ValueTypeGuiElement.SubGuiValueTypeInfo<SubGuiConfigRenderPattern, GuiLogicProgrammer, ContainerLogicProgrammer> {
        public static final int BUTTON_EDIT = 1;
        private GuiTextField searchField;
        private GuiButtonText button;

        public SubGuiOperatorInfo(IGuiInputElement<SubGuiConfigRenderPattern, GuiLogicProgrammer, ContainerLogicProgrammer> element) {
            super(GuiLogicProgrammer.this, (ContainerLogicProgrammer)GuiLogicProgrammer.this.container, element, 88, 106, 139, 20);
            this.button = null;
            if (GuiLogicProgrammer.this.hasLabeller()) {
                this.button = new GuiButtonText(1, 0, 0, 6, 10, "E", true);
                this.buttonList.add(this.button);
            }
            int searchWidth = 113;
            this.searchField = new GuiTextField(0, GuiLogicProgrammer.this.field_146289_q, 0, 0, searchWidth, 11);
            this.searchField.func_146203_f(64);
            this.searchField.func_146185_a(true);
            this.searchField.func_146189_e(false);
            this.searchField.func_146193_g(0xFFFFFF);
            this.searchField.func_146205_d(true);
            this.searchField.func_146180_a("");
            this.searchField.field_146218_h = searchWidth;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            int searchX = 90;
            int searchY = 110;
            this.searchField.field_146209_f = guiLeft + searchX;
            this.searchField.field_146210_g = guiTop + searchY;
            if (GuiLogicProgrammer.this.hasLabeller()) {
                this.button.field_146128_h = guiLeft + 220;
                this.button.field_146129_i = guiTop + 111;
            }
        }

        @Override
        protected boolean showError() {
            return ((ContainerLogicProgrammer)this.container).canWriteActiveElementPre();
        }

        @Override
        protected L10NHelpers.UnlocalizedString getLastError() {
            return ((ContainerLogicProgrammer)this.container).getLastError();
        }

        @Override
        protected ResourceLocation getTexture() {
            return GuiLogicProgrammer.this.texture;
        }

        @Override
        public boolean keyTyped(boolean checkHotbarKeys, char typedChar, int keyCode) throws IOException {
            if (!checkHotbarKeys) {
                if (!this.searchField.func_146176_q() || !this.searchField.func_146201_a(typedChar, keyCode)) {
                    return super.keyTyped(checkHotbarKeys, typedChar, keyCode);
                }
                GuiLogicProgrammer.this.label(this.searchField.func_146179_b());
                return true;
            }
            return super.keyTyped(checkHotbarKeys, typedChar, keyCode);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            if (this.searchField.func_146176_q()) {
                this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchField.func_146194_f();
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton.field_146127_k == 1) {
                this.searchField.func_146189_e(!this.searchField.func_146176_q());
                if (this.searchField.func_146176_q()) {
                    this.searchField.func_146195_b(true);
                    GuiLogicProgrammer.this.label(this.searchField.func_146179_b());
                } else {
                    GuiLogicProgrammer.this.label("");
                }
            }
        }
    }
}

