/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.base.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModelBase;

public class CableModel
extends CableModelBase {
    public CableModel(IExtendedBlockState state, boolean isItemStack) {
        super(state, isItemStack);
    }

    public CableModel() {
    }

    @Override
    protected boolean isRealCable() {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.REALCABLE, (Object)true);
    }

    @Override
    protected Optional<IBlockState> getFacade() {
        return (Optional)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.FACADE, (Object)Optional.absent());
    }

    @Override
    protected boolean isConnected(EnumFacing side) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    protected boolean hasPart(EnumFacing side) {
        return this.getPartRenderPosition(side) != IPartType.RenderPosition.NONE;
    }

    @Override
    protected IPartType.RenderPosition getPartRenderPosition(EnumFacing side) {
        return (IPartType.RenderPosition)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)IPartType.RenderPosition.NONE);
    }

    @Override
    protected boolean shouldRenderParts() {
        return MinecraftForgeClient.getRenderLayer() == EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    protected IBakedModel getPartModel(EnumFacing side) {
        IPartContainer partContainer = (IPartContainer)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PARTCONTAINER, null);
        IBlockState blockState = partContainer != null && partContainer.hasPart(side) ? partContainer.getPart(side).getBlockState(partContainer, side) : null;
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        return blockModelShapes.func_178125_b(blockState);
    }

    public IBakedModel handleBlockState(IBlockState state) {
        return new CableModel((IExtendedBlockState)state, false);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        return new CableModel((IExtendedBlockState)BlockCable.getInstance().func_176223_P(), true);
    }
}

