/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.client.model.DynamicModel;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;

public abstract class CableModelBase
extends DynamicModel {
    private static final int RADIUS = 4;
    private static final int TEXTURE_SIZE = 16;
    private static final int LENGTH_CONNECTION = 6;
    private static final int LENGTH_CONNECTION_LIMITED = 1;
    private static final int INV_LENGTH_CONNECTION = 10;
    public static final float MIN = 0.375f;
    public static final float MAX = 0.625f;
    private static final IPartType.RenderPosition CABLE_RENDERPOSITION = new IPartType.RenderPosition(-1.0f, 0.375f, 0.25f, 0.25f);
    private final float[][][] quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f);

    public CableModelBase(IExtendedBlockState state, boolean isItemStack) {
        super(state, isItemStack);
    }

    public CableModelBase() {
    }

    protected static float[][][] makeQuadVertexes(float min, float max, float length) {
        return new float[][][]{new float[][]{{min, length, min}, {max, length, min}, {max, max, min}, {min, max, min}}, new float[][]{{min, max, min}, {min, max, max}, {min, length, max}, {min, length, min}}, new float[][]{{min, max, max}, {max, max, max}, {max, length, max}, {min, length, max}}, new float[][]{{max, length, min}, {max, length, max}, {max, max, max}, {max, max, min}}};
    }

    private EnumFacing getSideFromVecs(Vec3 a, Vec3 b, Vec3 c) {
        int dir;
        int n = a.field_72448_b == b.field_72448_b && b.field_72448_b == c.field_72448_b ? 0 : (dir = a.field_72450_a == b.field_72450_a && b.field_72450_a == c.field_72450_a ? 2 : 4);
        if (dir == 0) {
            dir += c.field_72448_b >= 0.5 ? 1 : 0;
        } else if (dir == 2) {
            dir += c.field_72450_a >= 0.5 ? 1 : 0;
        } else if (dir == 4) {
            dir += c.field_72449_c >= 0.5 ? 1 : 0;
        }
        return EnumFacing.func_82600_a((int)dir);
    }

    public List<BakedQuad> getFacadeQuads(IBlockState blockState, EnumFacing side, IPartType.RenderPosition renderPosition) {
        LinkedList ret = Lists.newLinkedList();
        IBakedModel model = RenderHelpers.getBakedModel((IBlockState)blockState);
        TextureAtlasSprite texture = model.func_177554_e();
        if (renderPosition == IPartType.RenderPosition.NONE) {
            CableModelBase.addBakedQuad((List)ret, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
        } else {
            float w = renderPosition.getWidthFactor();
            float h = renderPosition.getHeightFactor();
            float x0 = 0.0f;
            float x1 = (1.0f - w) / 2.0f;
            float x2 = x1 + w;
            float x3 = 1.0f;
            float z0 = 0.0f;
            float z1 = (1.0f - h) / 2.0f;
            float z2 = z1 + h;
            float z3 = 1.0f;
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x1, (float)x2, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z0, (float)z1, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z1, (float)z2, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z1, (float)z2, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x0, (float)x1, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x1, (float)x2, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
            CableModelBase.addBakedQuad((List)ret, (float)x2, (float)x3, (float)z2, (float)z3, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)side);
        }
        return ret;
    }

    protected abstract boolean isRealCable();

    protected abstract Optional<IBlockState> getFacade();

    protected abstract boolean isConnected(EnumFacing var1);

    protected abstract boolean hasPart(EnumFacing var1);

    protected abstract IPartType.RenderPosition getPartRenderPosition(EnumFacing var1);

    protected abstract boolean shouldRenderParts();

    protected abstract IBakedModel getPartModel(EnumFacing var1);

    public List<BakedQuad> func_177550_a() {
        LinkedList ret = Lists.newLinkedList();
        TextureAtlasSprite texture = this.func_177554_e();
        boolean renderCable = this.isItemStack() || this.isRealCable() && MinecraftForgeClient.getRenderLayer() == EnumWorldBlockLayer.TRANSLUCENT;
        Optional<IBlockState> blockStateHolder = this.getFacade();
        for (EnumFacing side : EnumFacing.values()) {
            boolean hasPart;
            boolean isConnected = this.isItemStack() ? side == EnumFacing.EAST || side == EnumFacing.WEST : this.isConnected(side);
            boolean bl = hasPart = !this.isItemStack() && this.hasPart(side);
            if (hasPart && this.shouldRenderParts()) {
                ret.addAll(this.getPartModel(side).func_177550_a());
            }
            if (!renderCable) continue;
            IPartType.RenderPosition renderPosition = IPartType.RenderPosition.NONE;
            if (isConnected) {
                renderPosition = CABLE_RENDERPOSITION;
            }
            if (isConnected || hasPart) {
                int i = 0;
                float[][][] quadVertexes = this.quadVertexes;
                if (hasPart) {
                    renderPosition = this.getPartRenderPosition(side);
                    float depthFactor = renderPosition == IPartType.RenderPosition.NONE ? 0.0f : renderPosition.getDepthFactor();
                    quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f - depthFactor);
                }
                for (float[][] v : quadVertexes) {
                    Vec3 v1 = CableModelBase.rotate((Vec3)new Vec3((double)v[0][0] - 0.5, (double)v[0][1] - 0.5, (double)v[0][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                    Vec3 v2 = CableModelBase.rotate((Vec3)new Vec3((double)v[1][0] - 0.5, (double)v[1][1] - 0.5, (double)v[1][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                    Vec3 v3 = CableModelBase.rotate((Vec3)new Vec3((double)v[2][0] - 0.5, (double)v[2][1] - 0.5, (double)v[2][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                    Vec3 v4 = CableModelBase.rotate((Vec3)new Vec3((double)v[3][0] - 0.5, (double)v[3][1] - 0.5, (double)v[3][2] - 0.5), (EnumFacing)side).func_72441_c(0.5, 0.5, 0.5);
                    EnumFacing realSide = this.getSideFromVecs(v1, v2, v3);
                    boolean invert = i == 2 || i == 1;
                    int length = hasPart ? 1 : 6;
                    int[] data = Ints.concat((int[][])new int[][]{CableModelBase.vertexToInts((float)((float)v1.field_72450_a), (float)((float)v1.field_72448_b), (float)((float)v1.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v2.field_72450_a), (float)((float)v2.field_72448_b), (float)((float)v2.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v3.field_72450_a), (float)((float)v3.field_72448_b), (float)((float)v3.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? 0.0f : (float)length)), CableModelBase.vertexToInts((float)((float)v4.field_72450_a), (float)((float)v4.field_72448_b), (float)((float)v4.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? 0.0f : (float)length))});
                    ++i;
                    ForgeHooksClient.fillNormal((int[])data, (EnumFacing)realSide);
                    ret.add(new BakedQuad(data, -1, realSide));
                }
            } else {
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)0.625f, (TextureAtlasSprite)texture, (EnumFacing)side);
            }
            if (!blockStateHolder.isPresent()) continue;
            ret.addAll(this.getFacadeQuads((IBlockState)blockStateHolder.get(), side, renderPosition));
        }
        if (this.isItemStack()) {
            CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)EnumFacing.EAST);
            CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (EnumFacing)EnumFacing.WEST);
        }
        return ret;
    }

    public TextureAtlasSprite func_177554_e() {
        return BlockCable.getInstance().texture;
    }
}

