/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.part;

import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRendererBase;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;

@SideOnly(value=Side.CLIENT)
public class DisplayPartOverlayRenderer
extends PartOverlayRendererBase {
    protected static final float pixel = 0.0625f;

    @Override
    protected void setMatrixOrientation(EnumFacing direction) {
        super.setMatrixOrientation(direction);
        float translateX = -1.0f - (float)direction.func_82601_c() + 0.25f;
        float translateY = 1.0f - (float)direction.func_96559_d() - 0.25f;
        float translateZ = (float)direction.func_82599_e() - 0.0625f + 0.0025f;
        if (direction == EnumFacing.NORTH) {
            translateZ += 1.0f;
        } else if (direction == EnumFacing.EAST) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == EnumFacing.SOUTH) {
            translateX += 1.0f;
        } else if (direction == EnumFacing.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == EnumFacing.DOWN) {
            translateX += 1.0f;
            translateY -= 1.0f;
        }
        GlStateManager.func_179109_b((float)translateX, (float)translateY, (float)translateZ);
    }

    @Override
    public void renderPartOverlay(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, TileEntityRendererDispatcher rendererDispatcher) {
        BlockPos pos = partContainer.getPosition().getBlockPos();
        if (!this.shouldRender(pos)) {
            return;
        }
        EntityPlayerSP renderEntity = FMLClientHandler.instance().getClient().field_71439_g;
        float distanceFactor = (float)(((double)this.getMaxRenderDistance() - renderEntity.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) / 5.0);
        float distanceAlpha = Math.min(1.0f, distanceFactor);
        if (distanceAlpha < 0.05f) {
            distanceAlpha = 0.05f;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 0.04f;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.setMatrixOrientation(direction);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        PartTypePanelDisplay.State partState = (PartTypePanelDisplay.State)partContainer.getPartState(direction);
        if (partState == null || partState.getFacingRotation() == null) {
            this.drawError(rendererDispatcher, distanceAlpha);
        } else {
            int rotation = partState.getFacingRotation().ordinal() - 2;
            GlStateManager.func_179109_b((float)6.0f, (float)6.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(rotation * 90), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-6.0f, (float)-6.0f, (float)0.0f);
            IValue value = partState.getDisplayValue();
            if (value != null && partState.isEnabled()) {
                IValueType valueType = value.getType();
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(valueType);
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(partContainer, x, y, z, partialTick, destroyStage, direction, partType, value, rendererDispatcher, distanceAlpha);
            } else if (!partState.getInventory().isEmpty()) {
                this.drawError(rendererDispatcher, distanceAlpha);
            }
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawError(TileEntityRendererDispatcher rendererDispatcher, float distanceAlpha) {
        Images.ERROR.drawWorldWithAlpha(rendererDispatcher.field_147553_e, 12.5f, 12.5f, distanceAlpha);
    }
}

