/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.tileentity.TileDryingBasin;

public class RenderTileEntityDryingBasin
extends TileEntitySpecialRenderer<TileDryingBasin>
implements RenderHelpers.IFluidContextRender {
    private TileDryingBasin lastTile;

    public void renderTileEntityAt(TileDryingBasin tile, double x, double y, double z, float partialTickTime, int partialDamage) {
        if (tile != null) {
            if (tile.func_70301_a(0) != null) {
                GlStateManager.func_179094_E();
                float var10 = (float)(x - 0.5);
                float var11 = (float)(y - 0.5);
                float var12 = (float)(z - 0.5);
                GlStateManager.func_179109_b((float)var10, (float)var11, (float)var12);
                this.renderItem(tile.func_145831_w(), tile.func_70301_a(0), tile.getRandomRotation());
                GlStateManager.func_179121_F();
            }
            this.lastTile = tile;
            RenderHelpers.renderTileFluidContext((FluidStack)tile.getTank().getFluid(), (double)x, (double)y, (double)z, (TileEntity)tile, (RenderHelpers.IFluidContextRender)this);
        }
    }

    private void renderItem(World world, ItemStack itemStack, float rotation) {
        GlStateManager.func_179094_E();
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            GlStateManager.func_179109_b((float)1.0f, (float)1.2f, (float)1.0f);
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
        } else {
            GlStateManager.func_179109_b((float)1.0f, (float)1.2f, (float)1.0f);
            GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        RenderHelpers.renderItem((ItemStack)itemStack);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void renderFluid(FluidStack fluid) {
        double height = (double)fluid.amount * 0.7 / 1000.0 + 0.23 + 0.01;
        int brightness = this.lastTile.func_145831_w().func_175626_b(this.lastTile.func_174877_v(), fluid.getFluid().getLuminosity(fluid));
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)this.lastTile.getTank().getFluid(), (EnumFacing)EnumFacing.UP);
        Tessellator t = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = t.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        worldRenderer.func_181662_b(0.0, height, 0.0).func_181673_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(0.0, height, 1.0).func_181673_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(1.0, height, 1.0).func_181673_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(1.0, height, 0.0).func_181673_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_181671_a(l2, i3).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        t.func_78381_a();
    }
}

