/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.integrateddynamics.core.block.ICollidable;
import org.cyclops.integrateddynamics.core.block.ICollidableParent;

public class CollidableComponent<P, B extends Block>
implements ICollidable {
    private final B block;
    private final List<ICollidable.IComponent<P, B>> components;
    private final int totalComponents;

    public CollidableComponent(B block, List<ICollidable.IComponent<P, B>> components) {
        this.block = block;
        this.components = components;
        int count = 0;
        for (ICollidable.IComponent<P, B> component : components) {
            for (P position : component.getPossiblePositions()) {
                count += component.getBoundsCount(position);
            }
        }
        this.totalComponents = count;
    }

    private void addComponentCollisionBoxesToList(ICollidable.IComponent<EnumFacing, B> component, World world, BlockPos pos, IBlockState state, AxisAlignedBB axisalignedbb, List list, Entity collidingEntity) {
        for (EnumFacing position : component.getPossiblePositions()) {
            if (!component.isActive(this.getBlock(), world, pos, position)) continue;
            for (AxisAlignedBB bb : component.getBounds(this.getBlock(), world, pos, position)) {
                this.setBlockBounds(bb);
                ((ICollidableParent)this.getBlock()).addCollisionBoxesToListParent(world, pos, state, axisalignedbb, list, collidingEntity);
            }
        }
    }

    @Override
    public void addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB axisalignedbb, List list, Entity collidingEntity) {
        for (ICollidable.IComponent<P, B> component : this.components) {
            this.addComponentCollisionBoxesToList(component, world, pos, state, axisalignedbb, list, collidingEntity);
        }
        this.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(World world, BlockPos pos) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.getBoundingBox() != null) {
            AxisAlignedBB box = rayTraceResult.getBoundingBox();
            return box.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        return ((ICollidableParent)this.getBlock()).getSelectedBoundingBoxParent(world, pos).func_72314_b(-0.625, -0.625, -0.625);
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        ICollidable.RayTraceResult raytraceResult = this.doRayTrace(world, pos, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.getMovingObjectPosition();
    }

    public ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        double reachDistance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0;
        double eyeHeight = world.field_72995_K ? (double)player.func_70047_e() : (double)player.func_70047_e();
        Vec3 lookVec = player.func_70040_Z();
        Vec3 origin = new Vec3(player.field_70165_t, player.field_70163_u + eyeHeight, player.field_70161_v);
        Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, pos, origin, direction);
    }

    private int doRayTraceComponent(ICollidable.IComponent<P, B> component, int countStart, World world, BlockPos pos, Vec3 origin, Vec3 direction, MovingObjectPosition[] hits, AxisAlignedBB[] boxes, P[] sideHit, ICollidable.IComponent<P, B>[] components) {
        int i = countStart;
        for (P position : component.getPossiblePositions()) {
            if (component.isActive(this.getBlock(), world, pos, position)) {
                int offset = 0;
                for (AxisAlignedBB bb : component.getBounds(this.getBlock(), world, pos, position)) {
                    this.setBlockBounds(bb);
                    boxes[i + offset] = bb;
                    hits[i + offset] = ((ICollidableParent)this.getBlock()).collisionRayTraceParent(world, pos, origin, direction);
                    sideHit[i + offset] = position;
                    components[i + offset] = component;
                    ++offset;
                }
            }
            i += component.getBoundsCount(position);
        }
        return i;
    }

    private ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        MovingObjectPosition[] hits = new MovingObjectPosition[this.totalComponents];
        AxisAlignedBB[] boxes = new AxisAlignedBB[this.totalComponents];
        Object[] sideHit = new Object[this.totalComponents];
        ICollidable.IComponent[] componentsOutput = new ICollidable.IComponent[this.totalComponents];
        Arrays.fill(sideHit, null);
        int count = 0;
        for (ICollidable.IComponent<P, B> component : this.components) {
            count = this.doRayTraceComponent(component, count, world, pos, origin, direction, hits, boxes, sideHit, componentsOutput);
        }
        double minDistance = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double d;
            if (hits[i] == null || !((d = hits[i].field_72307_f.func_72436_e(origin)) < minDistance)) continue;
            minDistance = d;
            minIndex = i;
        }
        this.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (minIndex != -1) {
            return new ICollidable.RayTraceResult<Object>(hits[minIndex], boxes[minIndex], sideHit[minIndex], componentsOutput[minIndex]);
        }
        return null;
    }

    private void setBlockBounds(AxisAlignedBB bounds) {
        this.getBlock().func_149676_a((float)bounds.field_72340_a, (float)bounds.field_72338_b, (float)bounds.field_72339_c, (float)bounds.field_72336_d, (float)bounds.field_72337_e, (float)bounds.field_72334_f);
    }

    public B getBlock() {
        return this.block;
    }

    public List<ICollidable.IComponent<P, B>> getComponents() {
        return this.components;
    }

    public int getTotalComponents() {
        return this.totalComponents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollidableComponent)) {
            return false;
        }
        CollidableComponent other = (CollidableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        B this$block = this.getBlock();
        B other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        List<ICollidable.IComponent<P, B>> this$components = this.getComponents();
        List<ICollidable.IComponent<P, B>> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        return this.getTotalComponents() == other.getTotalComponents();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollidableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        B $block = this.getBlock();
        result = result * 59 + ($block == null ? 0 : $block.hashCode());
        List<ICollidable.IComponent<P, B>> $components = this.getComponents();
        result = result * 59 + ($components == null ? 0 : ((Object)$components).hashCode());
        result = result * 59 + this.getTotalComponents();
        return result;
    }

    public String toString() {
        return "CollidableComponent(block=" + this.getBlock() + ", components=" + this.getComponents() + ", totalComponents=" + this.getTotalComponents() + ")";
    }
}

