/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ICollidable<P> {
    public Block getBlock();

    public void addCollisionBoxesToList(World var1, BlockPos var2, IBlockState var3, AxisAlignedBB var4, List var5, Entity var6);

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(World var1, BlockPos var2);

    public RayTraceResult<P> doRayTrace(World var1, BlockPos var2, EntityPlayer var3);

    public MovingObjectPosition collisionRayTrace(World var1, BlockPos var2, Vec3 var3, Vec3 var4);

    public static interface IComponent<P, B> {
        public Collection<P> getPossiblePositions();

        public int getBoundsCount(P var1);

        public boolean isActive(B var1, World var2, BlockPos var3, P var4);

        public List<AxisAlignedBB> getBounds(B var1, World var2, BlockPos var3, P var4);

        public ItemStack getPickBlock(World var1, BlockPos var2, P var3);

        public boolean destroy(World var1, BlockPos var2, P var3, EntityPlayer var4);

        @SideOnly(value=Side.CLIENT)
        @Nullable
        public IBakedModel getBreakingBaseModel(World var1, BlockPos var2, P var3);
    }

    public static class RayTraceResult<P> {
        private final MovingObjectPosition movingObjectPosition;
        private final AxisAlignedBB boundingBox;
        private final P positionHit;
        private final IComponent<P, ?> collisionType;

        public String toString() {
            return String.format("RayTraceResult: %s %s", this.boundingBox, this.collisionType);
        }

        @ConstructorProperties(value={"movingObjectPosition", "boundingBox", "positionHit", "collisionType"})
        public RayTraceResult(MovingObjectPosition movingObjectPosition, AxisAlignedBB boundingBox, P positionHit, IComponent<P, ?> collisionType) {
            this.movingObjectPosition = movingObjectPosition;
            this.boundingBox = boundingBox;
            this.positionHit = positionHit;
            this.collisionType = collisionType;
        }

        public MovingObjectPosition getMovingObjectPosition() {
            return this.movingObjectPosition;
        }

        public AxisAlignedBB getBoundingBox() {
            return this.boundingBox;
        }

        public P getPositionHit() {
            return this.positionHit;
        }

        public IComponent<P, ?> getCollisionType() {
            return this.collisionType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RayTraceResult)) {
                return false;
            }
            RayTraceResult other = (RayTraceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MovingObjectPosition this$movingObjectPosition = this.getMovingObjectPosition();
            MovingObjectPosition other$movingObjectPosition = other.getMovingObjectPosition();
            if (this$movingObjectPosition == null ? other$movingObjectPosition != null : !this$movingObjectPosition.equals(other$movingObjectPosition)) {
                return false;
            }
            AxisAlignedBB this$boundingBox = this.getBoundingBox();
            AxisAlignedBB other$boundingBox = other.getBoundingBox();
            if (this$boundingBox == null ? other$boundingBox != null : !this$boundingBox.equals(other$boundingBox)) {
                return false;
            }
            P this$positionHit = this.getPositionHit();
            P other$positionHit = other.getPositionHit();
            if (this$positionHit == null ? other$positionHit != null : !this$positionHit.equals(other$positionHit)) {
                return false;
            }
            IComponent<P, ?> this$collisionType = this.getCollisionType();
            IComponent<P, ?> other$collisionType = other.getCollisionType();
            return !(this$collisionType == null ? other$collisionType != null : !this$collisionType.equals(other$collisionType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RayTraceResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MovingObjectPosition $movingObjectPosition = this.getMovingObjectPosition();
            result = result * 59 + ($movingObjectPosition == null ? 0 : $movingObjectPosition.hashCode());
            AxisAlignedBB $boundingBox = this.getBoundingBox();
            result = result * 59 + ($boundingBox == null ? 0 : $boundingBox.hashCode());
            P $positionHit = this.getPositionHit();
            result = result * 59 + ($positionHit == null ? 0 : $positionHit.hashCode());
            IComponent<P, ?> $collisionType = this.getCollisionType();
            result = result * 59 + ($collisionType == null ? 0 : $collisionType.hashCode());
            return result;
        }
    }
}

