/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block.cable;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;

public class NetworkElementProviderComponent<N extends INetwork> {
    private final INetworkElementProvider<N> networkElementProvider;

    public NetworkElementProviderComponent(INetworkElementProvider<N> networkElementProvider) {
        this.networkElementProvider = networkElementProvider;
    }

    public void onPreBlockDestroyed(N network, World world, BlockPos pos, boolean dropMainElement) {
        if (!world.field_72995_K) {
            LinkedList itemStacks = Lists.newLinkedList();
            for (INetworkElement<N> networkElement : this.networkElementProvider.createNetworkElements(world, pos)) {
                networkElement.addDrops(itemStacks, dropMainElement);
                networkElement.onPreRemoved(network);
                network.removeNetworkElementPre(networkElement);
                network.removeNetworkElementPost(networkElement);
            }
            for (ItemStack itemStack : itemStacks) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
            }
        }
    }

    public void onBlockNeighborChange(N network, World world, BlockPos pos, Block neighborBlock) {
        if (!world.field_72995_K) {
            for (INetworkElement<N> networkElement : this.networkElementProvider.createNetworkElements(world, pos)) {
                networkElement.onNeighborBlockChange(network, (IBlockAccess)world, neighborBlock);
            }
        }
    }
}

