/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.client.model.BakedMapVariableModelProvider;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class AspectVariableModelProvider
implements IVariableModelProvider<BakedMapVariableModelProvider<IAspect>> {
    @Override
    public BakedMapVariableModelProvider<IAspect> bakeOverlayModels(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashMap bakedModels = Maps.newHashMap();
        for (IAspect aspect : Aspects.REGISTRY.getAspects()) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)Aspects.REGISTRY.getAspectModel(aspect));
                IFlexibleBakedModel bakedAspectModel = model.bake(state, format, bakedTextureGetter);
                bakedModels.put(aspect, bakedAspectModel);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new BakedMapVariableModelProvider<IAspect>(bakedModels);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Aspects.REGISTRY.getAspectModels();
    }
}

