/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;

public class OperatorRegistry
implements IOperatorRegistry {
    private static OperatorRegistry INSTANCE = new OperatorRegistry();
    private static final IOperatorVariableFacade INVALID_FACADE = new OperatorVariableFacade(false, null, null);
    private final List<IOperator> operators = Lists.newLinkedList();
    private final Map<String, IOperator> namedOperators = Maps.newHashMap();
    private final Multimap<List<IValueType>, IOperator> inputTypedOperators = HashMultimap.create();
    private final Multimap<IValueType, IOperator> outputTypedOperators = HashMultimap.create();

    private OperatorRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        }
    }

    public static OperatorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <O extends IOperator> O register(O operator) {
        this.operators.add(operator);
        this.namedOperators.put(operator.getUniqueName(), operator);
        this.inputTypedOperators.put((Object)Lists.newArrayList((Object[])operator.getInputTypes()), operator);
        this.outputTypedOperators.put((Object)operator.getOutputType(), operator);
        return operator;
    }

    @Override
    public Collection<IOperator> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    @Override
    public IOperator getOperator(String uniqueName) {
        return this.namedOperators.get(uniqueName);
    }

    @Override
    public Collection<IOperator> getOperatorsWithInputTypes(IValueType ... valueTypes) {
        return this.inputTypedOperators.get((Object)Lists.newArrayList((Object[])valueTypes));
    }

    @Override
    public Collection<IOperator> getOperatorsWithOutputType(IValueType valueType) {
        return this.outputTypedOperators.get((Object)valueType);
    }

    @Override
    public String getTypeId() {
        return "operator";
    }

    @Override
    public IOperatorVariableFacade getVariableFacade(int id, NBTTagCompound tag) {
        if (!tag.func_150297_b("operatorName", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal()) || !tag.func_150297_b("variableIds", MinecraftHelpers.NBTTag_Types.NBTTagIntArray.ordinal())) {
            return INVALID_FACADE;
        }
        IOperator operator = this.getOperator(tag.func_74779_i("operatorName"));
        if (operator == null) {
            return INVALID_FACADE;
        }
        int[] variableIds = tag.func_74759_k("variableIds");
        return new OperatorVariableFacade(id, operator, variableIds);
    }

    @Override
    public void setVariableFacade(NBTTagCompound tag, IOperatorVariableFacade variableFacade) {
        tag.func_74778_a("operatorName", variableFacade.getOperator().getUniqueName());
        tag.func_74783_a("variableIds", variableFacade.getVariableIds());
    }
}

