/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.build.OperatorBuilder;
import org.cyclops.integrateddynamics.core.evaluate.operator.CompositionalOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralChoiceOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralIdentityOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityArmorInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.helper.obfuscation.ObfuscationHelpers;

public final class Operators {
    public static final IOperatorRegistry REGISTRY = Operators.constructRegistry();
    public static final IOperator LOGICAL_AND = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("&&").operatorName("and").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeBoolean.ValueBoolean a = (ValueTypeBoolean.ValueBoolean)variables.getValue(0);
            if (!a.getRawValue()) {
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return variables.getValue(1);
        }
    }).build());
    public static final IOperator LOGICAL_OR = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("||").operatorName("or").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeBoolean.ValueBoolean a = (ValueTypeBoolean.ValueBoolean)variables.getValue(0);
            if (a.getRawValue()) {
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return variables.getValue(1);
        }
    }).build());
    public static final IOperator LOGICAL_NOT = REGISTRY.register(OperatorBuilders.LOGICAL_1_PREFIX.symbol("!").operatorName("not").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(!((ValueTypeBoolean.ValueBoolean)variables.getValue(0)).getRawValue());
        }
    }).build());
    public static final IOperator ARITHMETIC_ADDITION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("+").operatorName("addition").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.add(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_SUBTRACTION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("-").operatorName("subtraction").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.subtract(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MULTIPLICATION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("*").operatorName("multiplication").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.multiply(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_DIVISION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("/").operatorName("division").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.divide(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MAXIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("max").operatorName("maximum").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.max(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    public static final IOperator ARITHMETIC_MINIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("min").operatorName("minimum").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypes.CATEGORY_NUMBER.min(variables.getVariables()[0], variables.getVariables()[1]);
        }
    }).build());
    private static final ValueTypeInteger.ValueInteger ZERO = ValueTypeInteger.ValueInteger.of(0);
    public static final IOperator INTEGER_MODULUS = REGISTRY.register(OperatorBuilders.INTEGER_2.symbol("%").operatorName("modulus").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            if (b.getRawValue() == 0) {
                throw new EvaluationException("Division by zero");
            }
            if (b.getRawValue() == 1) {
                return ZERO;
            }
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() % b.getRawValue());
        }
    }).build());
    public static final IOperator INTEGER_INCREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("++").operatorName("increment").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() + 1);
        }
    }).build());
    public static final IOperator INTEGER_DECREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("--").operatorName("decrement").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() - 1);
        }
    }).build());
    public static final IOperator RELATIONAL_EQUALS = REGISTRY.register(OperatorBuilders.RELATIONAL.inputTypes(2, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbol("==").operatorName("equals").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeBoolean.ValueBoolean.of(variables.getValue(0).equals(variables.getValue(1)));
        }
    }).typeValidator(new OperatorBuilder.ITypeValidator(){

        @Override
        public L10NHelpers.UnlocalizedString validateTypes(OperatorBase operator, IValueType[] input) {
            int requiredInputLength = operator.getRequiredInputLength();
            if (input.length != requiredInputLength) {
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrongInputLength", new Object[]{operator.getOperatorName(), input.length, requiredInputLength});
            }
            IValueType temporarySecondInputType = null;
            for (int i = 0; i < requiredInputLength; ++i) {
                IValueType inputType = input[i];
                if (inputType == null) {
                    return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.nullType", new Object[]{operator.getOperatorName(), Integer.toString(i)});
                }
                if (i == 0) {
                    temporarySecondInputType = inputType;
                    continue;
                }
                if (i != 1 || temporarySecondInputType == inputType) continue;
                return new L10NHelpers.UnlocalizedString("operator.integrateddynamics.error.wrongType", new Object[]{operator.getOperatorName(), new L10NHelpers.UnlocalizedString(inputType.getUnlocalizedName(), new Object[0]), Integer.toString(i), new L10NHelpers.UnlocalizedString(temporarySecondInputType.getUnlocalizedName(), new Object[0])});
            }
            return null;
        }
    }).build());
    public static final IOperator RELATIONAL_GT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.symbol(">").operatorName("gt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue() > b.getRawValue());
        }
    }).build());
    public static final IOperator RELATIONAL_LT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.symbol("<").operatorName("lt").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue() < b.getRawValue());
        }
    }).build());
    public static final IOperator RELATIONAL_NOTEQUALS = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(RELATIONAL_EQUALS).build("!=", "notequals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_GE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_GT).build(">=", "ge", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_LE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_LT).build("<=", "le", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator BINARY_AND = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("&").operatorName("and").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() & b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_OR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("|").operatorName("or").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() | b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_XOR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("^").operatorName("xor").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() ^ b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_COMPLEMENT = REGISTRY.register(OperatorBuilders.BINARY_1_PREFIX.symbol("~").operatorName("complement").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(~a.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_LSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("<<").operatorName("lshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() << b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_RSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>").operatorName("rshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() >> b.getRawValue());
        }
    }).build());
    public static final IOperator BINARY_RZSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>>").operatorName("rzshift").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeInteger.ValueInteger a = (ValueTypeInteger.ValueInteger)variables.getValue(0);
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue() >>> b.getRawValue());
        }
    }).build());
    public static final IOperator STRING_LENGTH = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.symbol("len").operatorName("length").output(ValueTypes.INTEGER).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of(a.getRawValue().length());
        }
    }).build());
    public static final IOperator STRING_CONCAT = REGISTRY.register(OperatorBuilders.STRING_2.symbol("+").operatorName("concat").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            ValueTypeString.ValueString b = (ValueTypeString.ValueString)variables.getValue(1);
            return ValueTypeString.ValueString.of(a.getRawValue() + b.getRawValue());
        }
    }).build());
    public static final IOperator NAMED_NAME = REGISTRY.register(OperatorBuilders.STRING_2.symbol("name").operatorName("name").inputType(ValueTypes.CATEGORY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return ValueTypeString.ValueString.of(ValueTypes.CATEGORY_NAMED.getName(variables.getVariables()[0]));
        }
    }).build());
    public static final IOperator DOUBLE_ROUND = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("|| ||").operatorName("round").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.round(a.getRawValue()));
        }
    }).build());
    public static final IOperator DOUBLE_CEIL = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("\u2308 \u2309").operatorName("ceil").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.ceil(a.getRawValue()));
        }
    }).build());
    public static final IOperator DOUBLE_FLOOR = REGISTRY.register(OperatorBuilders.DOUBLE_1_PREFIX.output(ValueTypes.INTEGER).symbol("\u230a \u230b").operatorName("floor").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeDouble.ValueDouble a = (ValueTypeDouble.ValueDouble)variables.getValue(0);
            return ValueTypeInteger.ValueInteger.of((int)Math.floor(a.getRawValue()));
        }
    }).build());
    public static final IOperator NULLABLE_ISNULL = REGISTRY.register(OperatorBuilders.NULLABLE_1_PREFIX.symbol("o").operatorName("isnull").inputType(ValueTypes.CATEGORY_ANY).output(ValueTypes.BOOLEAN).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            if (ValueHelpers.correspondsTo(variables.getVariables()[0].getType(), ValueTypes.CATEGORY_NULLABLE)) {
                return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NULLABLE.isNull(variables.getVariables()[0]));
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
    }).build());
    public static final IOperator NULLABLE_ISNOTNULL = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(NULLABLE_ISNULL).build("\u2205", "isnotnull", IConfigRenderPattern.PREFIX_1, "general"));
    public static final IOperator LIST_LENGTH = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.INTEGER).symbol("| |").operatorName("length").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            return ValueTypeInteger.ValueInteger.of(a.getLength());
        }
    }).build());
    public static final IOperator LIST_ELEMENT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(new IValueType[]{ValueTypes.LIST, ValueTypes.INTEGER}).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbolOperator("get").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)variables.getValue(0)).getRawValue();
            ValueTypeInteger.ValueInteger b = (ValueTypeInteger.ValueInteger)variables.getValue(1);
            if (b.getRawValue() < a.getLength()) {
                return a.get(b.getRawValue());
            }
            return a.getValueType().getDefault();
        }
    }).conditionalOutputTypeDeriver(new OperatorBuilder.IConditionalOutputTypeDeriver(){

        @Override
        public IValueType getConditionalOutputType(OperatorBase operator, IVariable[] input) {
            try {
                IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
                return a.getValueType();
            }
            catch (EvaluationException e) {
                return operator.getConditionalOutputType(input);
            }
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_OPAQUE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("opaque").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((IBlockState)a.getRawValue().get()).func_177230_c().func_149662_c());
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_ITEMSTACK = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemstack").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return ValueObjectTypeItemStack.ValueItemStack.of(a.getRawValue().isPresent() ? BlockHelpers.getItemStackFromBlockState((IBlockState)((IBlockState)a.getRawValue().get())) : null);
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_MODNAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{new IOperatorValuePropagator<OperatorBase.SafeVariablesGetter, ResourceLocation>(){

        @Override
        public ResourceLocation getOutput(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeBlock.ValueBlock a = (ValueObjectTypeBlock.ValueBlock)variables.getValue(0);
            return a.getRawValue().isPresent() ? GameData.getBlockRegistry().getNameForObject((Object)((IBlockState)a.getRawValue().get()).func_177230_c()) : null;
        }
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_BLOCK_BREAKSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("breaksound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<Block.SoundType>, String>(){

        @Override
        public String getOutput(Optional<Block.SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((Block.SoundType)sound.get()).func_150495_a();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_PLACESOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("placesound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<Block.SoundType>, String>(){

        @Override
        public String getOutput(Optional<Block.SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((Block.SoundType)sound.get()).func_150496_b();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_STEPSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("stepsound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, new IOperatorValuePropagator<Optional<Block.SoundType>, String>(){

        @Override
        public String getOutput(Optional<Block.SoundType> sound) throws EvaluationException {
            if (sound.isPresent()) {
                return ((Block.SoundType)sound.get()).func_150498_e();
            }
            return "";
        }
    }, OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_ITEMSTACK_SIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("size").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? itemStack.field_77994_a : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxsize").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? itemStack.func_77976_d() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISSTACKABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("stackable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && itemStack.func_77985_e();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISDAMAGEABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("damageable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && itemStack.func_77984_f();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_DAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("damage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? itemStack.func_77952_i() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXDAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxdamage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? itemStack.func_77958_k() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTED = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchanted").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && itemStack.func_77948_v();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchantable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && itemStack.func_77956_u();
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_REPAIRCOST = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("repaircost").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? itemStack.func_82838_A() : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_RARITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueTypeString.ValueString.of(a.getRawValue().isPresent() ? ((ItemStack)a.getRawValue().get()).func_77953_t().field_77934_f : "");
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(new IValueType[]{ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK}).output(ValueTypes.DOUBLE).symbolOperator("strength").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ValueObjectTypeBlock.ValueBlock b = (ValueObjectTypeBlock.ValueBlock)variables.getValue(1);
            return ValueTypeDouble.ValueDouble.of(a.getRawValue().isPresent() && b.getRawValue().isPresent() ? (double)((ItemStack)a.getRawValue().get()).func_150997_a(((IBlockState)b.getRawValue().get()).func_177230_c()) : 0.0);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(new IValueType[]{ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK}).output(ValueTypes.BOOLEAN).symbolOperator("canharvest").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ValueObjectTypeBlock.ValueBlock b = (ValueObjectTypeBlock.ValueBlock)variables.getValue(1);
            return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && b.getRawValue().isPresent() && ((ItemStack)a.getRawValue().get()).func_150998_b(((IBlockState)b.getRawValue().get()).func_177230_c()));
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueObjectTypeBlock.ValueBlock.of(a.getRawValue().isPresent() && ((ItemStack)a.getRawValue().get()).func_77973_b() instanceof ItemBlock ? BlockHelpers.getBlockStateFromItemStack((ItemStack)((ItemStack)a.getRawValue().get())) : null);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isfluidstack").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<ItemStack, Boolean>(){

        @Override
        public Boolean getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null && Helpers.getFluidStack(itemStack) != null;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_FLUIDSTACK).symbolOperator("fluidstack").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return ValueObjectTypeFluidStack.ValueFluidStack.of(a.getRawValue().isPresent() ? Helpers.getFluidStack((ItemStack)a.getRawValue().get()) : null);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("fluidstackcapacity").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? Helpers.getFluidStackCapacity(itemStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_ISNBTEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NBT=").operatorName("isnbtequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
            Optional b = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (a.isPresent() && b.isPresent()) {
                equal = ((ItemStack)a.get()).func_77969_a((ItemStack)b.get()) && ItemStack.func_77970_a((ItemStack)((ItemStack)a.get()), (ItemStack)((ItemStack)b.get()));
            } else if (!a.isPresent() && !b.isPresent()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISRAWITEMEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwitemequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
            Optional b = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (a.isPresent() && b.isPresent()) {
                equal = ItemStack.func_179545_c((ItemStack)((ItemStack)a.get()), (ItemStack)((ItemStack)b.get()));
            } else if (!a.isPresent() && !b.isPresent()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_MODNAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{new IOperatorValuePropagator<OperatorBase.SafeVariablesGetter, ResourceLocation>(){

        @Override
        public ResourceLocation getOutput(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            return a.getRawValue().isPresent() ? GameData.getItemRegistry().getNameForObject((Object)((ItemStack)a.getRawValue().get()).func_77973_b()) : null;
        }
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_ITEMSTACK_FUELBURNTIME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("burntime").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(new IOperatorValuePropagator<ItemStack, Integer>(){

        @Override
        public Integer getOutput(ItemStack itemStack) throws EvaluationException {
            return itemStack != null ? TileEntityFurnace.func_145952_a((ItemStack)itemStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_OREDICT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("oredict").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0);
            ArrayList names = Lists.newArrayList();
            if (a.getRawValue().isPresent()) {
                for (int i : OreDictionary.getOreIDs((ItemStack)((ItemStack)a.getRawValue().get()))) {
                    names.add(ValueTypeString.ValueString.of(OreDictionary.getOreName((int)i)));
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, names);
        }
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_OREDICT_STACKS = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.symbolOperator("oredict").inputType(ValueTypes.STRING).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0);
            ArrayList stacks = Lists.newArrayList();
            if (!StringUtils.func_151246_b((String)a.getRawValue())) {
                for (ItemStack itemStack : OreDictionary.getOres((String)a.getRawValue())) {
                    stacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, stacks);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_ISMOB = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("ismob").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof IMob;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISANIMAL = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isanimal").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof IAnimals && !(entity instanceof IMob);
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISITEM = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isitem").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityItem;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISPLAYER = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isplayer").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityPlayer;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ITEMSTACK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("item").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            return ValueObjectTypeItemStack.ValueItemStack.of(a.isPresent() && a.get() instanceof EntityItem ? ((EntityItem)a.get()).func_92059_d() : null);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HEALTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("health").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity instanceof EntityLivingBase ? (double)((EntityLivingBase)entity).func_110143_aJ() : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_WIDTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("width").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity != null ? (double)entity.field_70130_N : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_HEIGHT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperator("height").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(new IOperatorValuePropagator<Entity, Double>(){

        @Override
        public Double getOutput(Entity entity) throws EvaluationException {
            return entity != null ? (double)entity.field_70131_O : 0.0;
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISBURNING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isburning").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70027_ad();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISWET = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("iswet").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70026_G();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISSNEAKING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("issneaking").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70093_af();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ISEATING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("iseating").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(new IOperatorValuePropagator<Entity, Boolean>(){

        @Override
        public Boolean getOutput(Entity entity) throws EvaluationException {
            return entity != null && entity.func_70113_ah();
        }
    })).build());
    public static final IOperator OBJECT_ENTITY_ARMORINVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("armorinventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            if (a.isPresent()) {
                Entity entity = (Entity)a.get();
                return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityArmorInventory(entity.field_70170_p, entity));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, Collections.emptyList());
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_INVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
            if (a.isPresent()) {
                Entity entity = (Entity)a.get();
                return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityInventory(entity.field_70170_p, entity));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, Collections.emptyList());
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_MODNAME = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String modName = "";
            if (a.getRawValue().isPresent()) {
                try {
                    Entity entity = (Entity)a.getRawValue().get();
                    EntityRegistry.EntityRegistration entityRegistration = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true);
                    modName = entityRegistration.getContainer().getName();
                }
                catch (NullPointerException e) {
                    modName = "Minecraft";
                }
            }
            return ValueTypeString.ValueString.of(modName);
        }
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETBLOCK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("targetblock").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            IBlockState blockState = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)a.getRawValue().get();
                double reachDistance = 5.0;
                double eyeHeight = entity.func_70047_e();
                if (entity instanceof EntityPlayerMP) {
                    reachDistance = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
                }
                Vec3 lookVec = entity.func_70040_Z();
                Vec3 origin = new Vec3(entity.field_70165_t, entity.field_70163_u + eyeHeight, entity.field_70161_v);
                Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
                MovingObjectPosition mop = entity.field_70170_p.func_72901_a(origin, direction, true);
                if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    blockState = entity.field_70170_p.func_180495_p(mop.func_178782_a());
                }
            }
            return ValueObjectTypeBlock.ValueBlock.of(blockState);
        }
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETENTITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ENTITY).symbolOperator("targetentity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            Entity entityOut = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)a.getRawValue().get();
                double reachDistance = 5.0;
                double eyeHeight = entity.func_70047_e();
                if (entity instanceof EntityPlayerMP) {
                    reachDistance = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
                }
                Vec3 lookVec = entity.func_70040_Z();
                Vec3 origin = new Vec3(entity.field_70165_t, entity.field_70163_u + eyeHeight, entity.field_70161_v);
                Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
                float size = entity.func_70111_Y();
                List list = entity.field_70170_p.func_72839_b((Entity)entity, entity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance).func_72314_b((double)size, (double)size, (double)size));
                for (Entity e : list) {
                    double distance;
                    if (!e.func_70067_L()) continue;
                    float f10 = e.func_70111_Y();
                    AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_72314_b((double)f10, (double)f10, (double)f10);
                    MovingObjectPosition mop = axisalignedbb.func_72327_a(origin, direction);
                    if (axisalignedbb.func_72318_a(origin)) {
                        entityOut = e;
                        continue;
                    }
                    if (mop == null || !((distance = origin.func_72438_d(mop.field_72307_f)) < reachDistance) && reachDistance != 0.0) continue;
                    if (e == entity.field_70154_o && !entity.canRiderInteract()) {
                        if (reachDistance != 0.0) continue;
                        entityOut = e;
                        continue;
                    }
                    entityOut = e;
                    reachDistance = distance;
                }
            }
            return ValueObjectTypeEntity.ValueEntity.of(entityOut);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("helditem").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ItemStack itemStack = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase) {
                itemStack = ((EntityLivingBase)a.getRawValue().get()).func_70694_bm();
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_MOUNTED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ENTITY).symbolOperator("mounted").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            Entity entityOut = null;
            if (a.getRawValue().isPresent()) {
                entityOut = ((Entity)a.getRawValue().get()).field_70153_n;
            }
            return ValueObjectTypeEntity.ValueEntity.of(entityOut);
        }
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_CONTENTS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemframecontents").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            ItemStack itemStack = null;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityItemFrame) {
                itemStack = ((EntityItemFrame)a.getRawValue().get()).func_82335_i();
            }
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_ROTATION = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("itemframerotation").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            Integer rotation = 0;
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityItemFrame) {
                rotation = ((EntityItemFrame)a.getRawValue().get()).func_82333_j();
            }
            return ValueTypeInteger.ValueInteger.of(rotation);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_HURTSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("hurtsound").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            String sound;
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String hurtSound = "";
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase && (sound = ObfuscationHelpers.getEntityLivingBaseHurtSound((EntityLivingBase)a.getRawValue().get())) != null) {
                hurtSound = sound;
            }
            return ValueTypeString.ValueString.of(hurtSound);
        }
    }).build());
    public static final IOperator OBJECT_ENTITY_DEATHSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("deathsound").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            String sound;
            ValueObjectTypeEntity.ValueEntity a = (ValueObjectTypeEntity.ValueEntity)variables.getValue(0);
            String hurtSound = "";
            if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof EntityLivingBase && (sound = ObfuscationHelpers.getEntityLivingBaseDeathSound((EntityLivingBase)a.getRawValue().get())) != null) {
                hurtSound = sound;
            }
            return ValueTypeString.ValueString.of(hurtSound);
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_AMOUNT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("amount").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.amount : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_BLOCK = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("block").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            return ValueObjectTypeBlock.ValueBlock.of(a.isPresent() ? ((FluidStack)a.get()).getFluid().getBlock().func_176223_P() : null);
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_LUMINOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("luminosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getLuminosity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_DENSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("density").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getDensity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_VISCOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("viscosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(new IOperatorValuePropagator<FluidStack, Integer>(){

        @Override
        public Integer getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null ? fluidStack.getFluid().getViscosity(fluidStack) : 0;
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISGASEOUS = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isgaseous").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_BOOLEAN.build(new IOperatorValuePropagator<FluidStack, Boolean>(){

        @Override
        public Boolean getOutput(FluidStack fluidStack) throws EvaluationException {
            return fluidStack != null && fluidStack.getFluid().isGaseous(fluidStack);
        }
    })).build());
    public static final IOperator OBJECT_FLUIDSTACK_RARITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("rarity").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            return ValueTypeString.ValueString.of(a.isPresent() ? ((FluidStack)a.get()).getFluid().getRarity((FluidStack)((FluidStack)a.get())).field_77934_f : "");
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwfluidequal").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Optional a = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0)).getRawValue();
            Optional b = ((ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(1)).getRawValue();
            boolean equal = false;
            if (a.isPresent() && b.isPresent()) {
                equal = ((FluidStack)a.get()).isFluidEqual((FluidStack)b.get());
            } else if (!a.isPresent() && !b.isPresent()) {
                equal = true;
            }
            return ValueTypeBoolean.ValueBoolean.of(equal);
        }
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_MODNAME = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("mod").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeFluidStack.ValueFluidStack a = (ValueObjectTypeFluidStack.ValueFluidStack)variables.getValue(0);
            String modName = "";
            if (a.getRawValue().isPresent()) {
                try {
                    Fluid fluid = ((FluidStack)a.getRawValue().get()).getFluid();
                    String modDomain = null;
                    if (fluid.getStill() != null) {
                        modDomain = fluid.getStill().func_110624_b();
                    } else if (fluid.getFlowing() != null) {
                        modDomain = fluid.getFlowing().func_110624_b();
                    } else if (fluid.getBlock() != null) {
                        modDomain = GameData.getBlockRegistry().getNameForObject((Object)fluid.getBlock()).func_110624_b();
                    }
                    String modId = org.cyclops.cyclopscore.helper.Helpers.getModId((String)modDomain);
                    modName = ((ModContainer)Loader.instance().getIndexedModList().get(modId)).getName();
                }
                catch (NullPointerException e) {
                    modName = "Minecraft";
                }
            }
            return ValueTypeString.ValueString.of(modName);
        }
    }).build());
    public static final GeneralOperator GENERAL_CHOICE = REGISTRY.register(new GeneralChoiceOperator("?", "choice"));
    public static final GeneralOperator GENERAL_IDENTITY = REGISTRY.register(new GeneralIdentityOperator("id", "identity"));

    private static IOperatorRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IOperatorRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IOperatorRegistry.class);
        }
        return OperatorRegistry.getInstance();
    }

    public static void load() {
    }
}

