/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.beans.ConstructorProperties;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueCastMappings;

public abstract class ValueBase
implements IValue {
    private final IValueType type;

    protected IValueCastRegistry getValueCastRegistry() {
        return ValueCastMappings.REGISTRY;
    }

    @Override
    public <V extends IValue> V cast(IValueType<V> valueType) throws IValueCastRegistry.ValueCastException {
        if (valueType == this.getType()) {
            return (V)this;
        }
        return (V)this.getValueCastRegistry().cast(valueType, this);
    }

    @Override
    public <V extends IValue> boolean canCast(IValueType<V> valueType) {
        return this.getValueCastRegistry().canCast(valueType, this);
    }

    @ConstructorProperties(value={"type"})
    public ValueBase(IValueType type) {
        this.type = type;
    }

    @Override
    public IValueType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueBase)) {
            return false;
        }
        ValueBase other = (ValueBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$type = this.getType();
        IValueType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "ValueBase(type=" + this.getType() + ")";
    }
}

