/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueObjectTypeEntity
extends ValueObjectTypeBase<ValueEntity>
implements IValueTypeNamed<ValueEntity>,
IValueTypeNullable<ValueEntity> {
    private static final String DELIMITER = ";";

    public ValueObjectTypeEntity() {
        super("entity");
    }

    @Override
    public ValueEntity getDefault() {
        return ValueEntity.of(null);
    }

    @Override
    public String toCompactString(ValueEntity value) {
        Optional entity = value.getRawValue();
        if (entity.isPresent()) {
            Entity e = (Entity)entity.get();
            if (e instanceof EntityItem) {
                return ((EntityItem)e).func_92059_d().func_82833_r();
            }
            return e.func_70005_c_();
        }
        return "";
    }

    @Override
    public String serialize(ValueEntity value) {
        Optional entity = value.getRawValue();
        if (entity.isPresent()) {
            int world = ((Entity)entity.get()).field_70170_p.field_73011_w.func_177502_q();
            int id = ((Entity)entity.get()).func_145782_y();
            return world + DELIMITER + id;
        }
        return "";
    }

    @Override
    public ValueEntity deserialize(String value) {
        String[] split = value.split(DELIMITER);
        Entity entity = null;
        if (split.length == 2) {
            try {
                int world = Integer.parseInt(split[0]);
                int id = Integer.parseInt(split[1]);
                if (MinecraftHelpers.isClientSide()) {
                    entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                } else {
                    WorldServer[] servers = MinecraftServer.func_71276_C().field_71305_c;
                    if (servers.length > world) {
                        entity = servers[world].func_73045_a(id);
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ValueEntity.of(entity);
    }

    @Override
    public String getName(ValueEntity a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueEntity a) {
        return !a.getRawValue().isPresent();
    }

    public static class ValueEntity
    extends ValueOptionalBase<Entity> {
        private ValueEntity(Entity entity) {
            super(ValueTypes.OBJECT_ENTITY, entity);
        }

        public static ValueEntity of(Entity entity) {
            return new ValueEntity(entity);
        }

        @Override
        protected boolean isEqual(Entity a, Entity b) {
            return a.func_145782_y() == b.func_145782_y();
        }

        @Override
        public String toString() {
            return "ValueObjectTypeEntity.ValueEntity()";
        }
    }
}

