/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeSubGuiRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;

public class ValueTypeGuiElement<G extends Gui, C extends Container>
implements IGuiInputElement<SubGuiConfigRenderPattern, G, C> {
    private final IValueType valueType;
    private final String defaultInputString;
    private String inputString;

    public ValueTypeGuiElement(IValueType valueType) {
        this.valueType = valueType;
        this.defaultInputString = this.getValueType().toCompactString(this.getValueType().getDefault());
    }

    public void setInputString(String inputString, ValueTypeSubGuiRenderPattern subGui) {
        this.inputString = inputString;
        if (subGui != null) {
            subGui.getSearchField().func_146180_a(inputString);
        }
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)this.getValueType().getUnlocalizedName());
    }

    @Override
    public void loadTooltip(List<String> lines) {
        this.getValueType().loadTooltip(lines, true);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }

    @Override
    public void activate() {
        this.inputString = new String(this.defaultInputString);
    }

    @Override
    public void deactivate() {
        this.inputString = null;
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        return this.getValueType().canDeserialize(this.inputString);
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getValueType().getUnlocalizedName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ValueTypeSubGuiRenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        return new ValueTypeSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public IValueType getValueType() {
        return this.valueType;
    }

    public String getDefaultInputString() {
        return this.defaultInputString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueTypeGuiElement)) {
            return false;
        }
        ValueTypeGuiElement other = (ValueTypeGuiElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$valueType = this.getValueType();
        IValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        String this$defaultInputString = this.getDefaultInputString();
        String other$defaultInputString = other.getDefaultInputString();
        if (this$defaultInputString == null ? other$defaultInputString != null : !this$defaultInputString.equals(other$defaultInputString)) {
            return false;
        }
        String this$inputString = this.getInputString();
        String other$inputString = other.getInputString();
        return !(this$inputString == null ? other$inputString != null : !this$inputString.equals(other$inputString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueTypeGuiElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 0 : $valueType.hashCode());
        String $defaultInputString = this.getDefaultInputString();
        result = result * 59 + ($defaultInputString == null ? 0 : $defaultInputString.hashCode());
        String $inputString = this.getInputString();
        result = result * 59 + ($inputString == null ? 0 : $inputString.hashCode());
        return result;
    }

    public String toString() {
        return "ValueTypeGuiElement(valueType=" + this.getValueType() + ", defaultInputString=" + this.getDefaultInputString() + ", inputString=" + this.getInputString() + ")";
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class SubGuiValueTypeInfo<S extends ISubGuiBox, G extends GuiContainerExtended, C extends Container>
    extends SubGuiBox.Base {
        private final IGuiInputElement element;
        protected final G gui;
        protected final C container;

        public SubGuiValueTypeInfo(G gui, C container, IGuiInputElement<S, G, C> element, int x, int y, int width, int height) {
            super(SubGuiBox.Box.DARK, x, y, width, height);
            this.gui = gui;
            this.container = container;
            this.element = element;
        }

        protected abstract boolean showError();

        protected abstract L10NHelpers.UnlocalizedString getLastError();

        protected abstract ResourceLocation getTexture();

        protected int getSignalX() {
            return this.getWidth() - 22;
        }

        protected int getSignalY() {
            return (this.getHeight() - 12) / 2;
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            fontRenderer.func_78276_b(this.element.getLocalizedNameFull(), x + 2, y + 6, Helpers.RGBToInt((int)240, (int)240, (int)240));
            if (this.showError()) {
                L10NHelpers.UnlocalizedString lastError = this.getLastError();
                if (lastError != null) {
                    Images.ERROR.draw((Gui)this, x + this.getSignalX(), y + this.getSignalY() - 1);
                } else {
                    Images.OK.draw((Gui)this, x + this.getSignalX(), y + this.getSignalY() + 1);
                }
            }
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            L10NHelpers.UnlocalizedString lastError;
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            int x = this.getX();
            int y = this.getY();
            if (this.showError() && (lastError = this.getLastError()) != null && this.gui.func_146978_c(x + this.getSignalX(), y + this.getSignalY() - 1, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), mouseX, mouseY)) {
                LinkedList lines = Lists.newLinkedList();
                lines.addAll(StringHelpers.splitLines((String)lastError.localize(), (int)25, (String)EnumChatFormatting.RED.toString()));
                this.gui.drawTooltip((List)lines, mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

