/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeList
extends ValueObjectTypeBase<ValueList> {
    public ValueTypeList() {
        super("list", Helpers.RGBToInt((int)175, (int)3, (int)1), EnumChatFormatting.DARK_RED.toString());
    }

    @Override
    public ValueList getDefault() {
        return ValueList.ofList(ValueTypes.CATEGORY_ANY, Lists.newArrayList());
    }

    @Override
    public String toCompactString(ValueList value) {
        return value.getRawValue().toCompactString();
    }

    @Override
    public String serialize(ValueList value) {
        try {
            return ValueTypeListProxyFactories.REGISTRY.serialize(value.getRawValue());
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public L10NHelpers.UnlocalizedString canDeserialize(String value) {
        try {
            Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(value);
            return null;
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            return new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]);
        }
    }

    @Override
    public ValueList deserialize(String value) {
        try {
            Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(value);
            return ValueList.ofFactory(proxy);
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            e.printStackTrace();
            return this.getDefault();
        }
    }

    @Override
    public ValueList materialize(ValueList value) {
        IValueTypeListProxy list = value.getRawValue();
        ArrayList values = Lists.newArrayListWithExpectedSize((int)list.getLength());
        for (IValue element : list) {
            values.add(element);
        }
        return ValueList.ofList(list.getValueType(), values);
    }

    public static class ListFactoryIterator<T extends IValueType<V>, V extends IValue>
    implements Iterator<V> {
        private final IValueTypeListProxy<T, V> value;
        private int index = 0;

        public ListFactoryIterator(IValueTypeListProxy<T, V> value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.value.getLength();
        }

        @Override
        public V next() {
            return this.value.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class ValueList<T extends IValueType<V>, V extends IValue>
    extends ValueBase {
        private final IValueTypeListProxy<T, V> value;

        private ValueList(IValueTypeListProxy<T, V> value) {
            super(ValueTypes.LIST);
            this.value = value;
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofList(T valueType, List<V> values) {
            return new ValueList<T, V>(new ValueTypeListProxyMaterialized<T, V>(valueType, values));
        }

        public static <V extends IValue> ValueList ofAll(V ... values) {
            return values.length == 0 ? ValueTypes.LIST.getDefault() : ValueList.ofList(values[0].getType(), Lists.newArrayList((Object[])values));
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofFactory(IValueTypeListProxy<T, V> proxy) {
            return new ValueList<T, V>(proxy);
        }

        public IValueTypeListProxy<T, V> getRawValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ValueList && ((ValueList)o).value.equals(this.value);
        }

        @Override
        public String toString() {
            return "ValueTypeList.ValueList(value=" + this.value + ")";
        }
    }
}

