/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import java.util.Map;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;

public class ValueTypeListProxyFactoryTypeRegistry
implements IValueTypeListProxyFactoryTypeRegistry {
    private static final String TYPE_DELIMITER = ";";
    private static final String TYPE_DELIMITER_SPLITREGEX = "(?<!\\\\);";
    private static final String TYPE_DELIMITER_ESCAPED = "\\\\;";
    private static ValueTypeListProxyFactoryTypeRegistry INSTANCE = new ValueTypeListProxyFactoryTypeRegistry();
    private final Map<String, IValueTypeListProxyFactoryTypeRegistry.IProxyFactory> factories = Maps.newHashMap();

    private ValueTypeListProxyFactoryTypeRegistry() {
    }

    public static ValueTypeListProxyFactoryTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>, F extends IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P>> F register(F proxyFactory) {
        if (this.factories.containsKey(proxyFactory.getName())) {
            throw new RuntimeException(String.format("A list proxy factory by name '%s' already exists.", proxyFactory.getName()));
        }
        this.factories.put(proxyFactory.getName(), proxyFactory);
        return proxyFactory;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> getFactory(String name) {
        return this.factories.get(name);
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> String serialize(P proxy) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(proxy.getName());
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No serialization factory exists for the list proxy type name '%s'.", proxy.getName()));
        }
        String serialized = factory.serialize(proxy);
        return proxy.getName() + TYPE_DELIMITER + serialized.replaceAll(TYPE_DELIMITER, TYPE_DELIMITER_ESCAPED);
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> P deserialize(String value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        String[] split = value.split(TYPE_DELIMITER_SPLITREGEX);
        if (split.length != 2) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s'.", value));
        }
        String name = split[0];
        String actualValue = split[1].replaceAll(TYPE_DELIMITER_ESCAPED, TYPE_DELIMITER);
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(name);
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No deserialization factory exists for the list proxy type name '%s'.", name));
        }
        return factory.deserialize(actualValue);
    }
}

