/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyPositionedTankCapacities
extends ValueTypeListProxyBase<ValueTypeInteger, ValueTypeInteger.ValueInteger>
implements INBTProvider {
    @NBTPersist
    private DimPos pos;
    @NBTPersist
    private EnumFacing side;

    public ValueTypeListProxyPositionedTankCapacities() {
        this(null, null);
    }

    public ValueTypeListProxyPositionedTankCapacities(DimPos pos, EnumFacing side) {
        super(ValueTypeListProxyFactories.POSITIONED_TANK_CAPACITIES.getName(), ValueTypes.INTEGER);
        this.pos = pos;
        this.side = side;
    }

    protected IFluidHandler getTank() {
        return (IFluidHandler)TileHelpers.getSafeTile((IBlockAccess)this.pos.getWorld(), (BlockPos)this.pos.getBlockPos(), IFluidHandler.class);
    }

    @Override
    public int getLength() {
        IFluidHandler tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        FluidTankInfo[] tanks = tank.getTankInfo(this.side);
        if (tanks == null) {
            return 0;
        }
        return tanks.length;
    }

    @Override
    public ValueTypeInteger.ValueInteger get(int index) {
        return ValueTypeInteger.ValueInteger.of(this.getTank().getTankInfo((EnumFacing)this.side)[index].capacity);
    }

    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
    }
}

