/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyPositionedTankFluidStacks
extends ValueTypeListProxyBase<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>
implements INBTProvider {
    @NBTPersist
    private DimPos pos;
    @NBTPersist
    private EnumFacing side;

    public ValueTypeListProxyPositionedTankFluidStacks() {
        this(null, null);
    }

    public ValueTypeListProxyPositionedTankFluidStacks(DimPos pos, EnumFacing side) {
        super(ValueTypeListProxyFactories.POSITIONED_TANK_FLUIDSTACKS.getName(), ValueTypes.OBJECT_FLUIDSTACK);
        this.pos = pos;
        this.side = side;
    }

    protected IFluidHandler getTank() {
        return (IFluidHandler)TileHelpers.getSafeTile((IBlockAccess)this.pos.getWorld(), (BlockPos)this.pos.getBlockPos(), IFluidHandler.class);
    }

    @Override
    public int getLength() {
        IFluidHandler tank = this.getTank();
        if (tank == null) {
            return 0;
        }
        FluidTankInfo[] tanks = tank.getTankInfo(this.side);
        if (tanks == null) {
            return 0;
        }
        return tanks.length;
    }

    @Override
    public ValueObjectTypeFluidStack.ValueFluidStack get(int index) {
        return ValueObjectTypeFluidStack.ValueFluidStack.of(this.getTank().getTankInfo((EnumFacing)this.side)[index].fluid);
    }

    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
    }
}

