/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    public static IPartType validatePartType(IPartNetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void writePartTypeToNBT(NBTTagCompound partTag, EnumFacing side, IPartType partType) {
        partTag.func_74778_a("__partType", partType.getName());
        partTag.func_74778_a("__side", side.func_176610_l());
    }

    public static boolean writePartToNBT(BlockPos pos, NBTTagCompound partTag, Pair<EnumFacing, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.writePartTypeToNBT(partTag, (EnumFacing)partData.getKey(), part);
        try {
            part.toNBT(partTag, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getName(), pos));
            return false;
        }
    }

    public static void writePartsToNBT(BlockPos pos, NBTTagCompound tag, Map<EnumFacing, PartStateHolder<?, ?>> partData) {
        NBTTagList partList = new NBTTagList();
        Iterator<Map.Entry<EnumFacing, PartStateHolder<?, ?>>> i$ = partData.entrySet().iterator();
        while (i$.hasNext()) {
            NBTTagCompound partTag = new NBTTagCompound();
            Map.Entry<EnumFacing, PartStateHolder<?, ?>> entry = i$.next();
            if (!PartHelpers.writePartToNBT(pos, partTag, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.func_74742_a((NBTBase)partTag);
        }
        tag.func_74782_a("parts", (NBTBase)partList);
    }

    public static Pair<EnumFacing, IPartType> readPartTypeFromNBT(@Nullable IPartNetwork network, BlockPos pos, NBTTagCompound partTag) {
        String partTypeName = partTag.func_74779_i("__partType");
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(partTypeName));
        if (partType != null) {
            EnumFacing side = EnumFacing.func_176739_a((String)partTag.func_74779_i("__side"));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getName(), pos));
        } else {
            IntegratedDynamics.clog(Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<EnumFacing, ? extends PartStateHolder<?, ?>> readPartFromNBT(@Nullable IPartNetwork network, BlockPos pos, NBTTagCompound partTag) {
        Pair<EnumFacing, IPartType> partData = PartHelpers.readPartTypeFromNBT(network, pos, partTag);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).fromNBT(partTag);
            return Pair.of((Object)partData.getKey(), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void readPartsFromNBT(@Nullable IPartNetwork network, BlockPos pos, NBTTagCompound tag, Map<EnumFacing, PartStateHolder<?, ?>> partData) {
        partData.clear();
        NBTTagList partList = tag.func_150295_c("parts", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < partList.func_74745_c(); ++i) {
            NBTTagCompound partTag = partList.func_150305_b(i);
            Pair<EnumFacing, ? extends PartStateHolder<?, ?>> part = PartHelpers.readPartFromNBT(network, pos, partTag);
            if (part == null) continue;
            partData.put((EnumFacing)part.getKey(), (PartStateHolder<?, ?>)part.getValue());
        }
    }

    public static boolean removePart(World world, BlockPos pos, EnumFacing side, @Nullable EntityPlayer player, boolean destroyIfEmpty) {
        IPartContainerFacade partContainerFacade = CableHelpers.getInterface((IBlockAccess)world, pos, IPartContainerFacade.class);
        ICable cable = CableHelpers.getInterface((IBlockAccess)world, pos, ICable.class);
        IPartContainer partContainer = partContainerFacade.getPartContainer((IBlockAccess)world, pos);
        partContainer.removePart(side, player);
        world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c());
        if (!(!destroyIfEmpty || cable instanceof ICableFakeable && ((ICableFakeable)cable).isRealCable(world, pos) || partContainer.hasParts())) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable IPartNetwork network, World world, BlockPos pos, EnumFacing side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainerFacade partContainerFacade = CableHelpers.getInterface((IBlockAccess)world, pos, IPartContainerFacade.class);
            INetworkElement<IPartNetwork> networkElement = part.createNetworkElement(partContainerFacade, DimPos.of((World)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.getDefaultState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        @ConstructorProperties(value={"part", "state"})
        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 0 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 0 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + this.getPart() + ", state=" + this.getState() + ")";
        }
    }
}

