/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import org.cyclops.integrateddynamics.api.item.IWrench;

public final class WrenchHelpers {
    public static boolean isWrench(EntityPlayer player, BlockPos pos) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        Item item = player.func_71045_bC().func_77973_b();
        return item instanceof IWrench && ((IWrench)item).canUse(player, pos);
    }

    public static <P> void wrench(EntityPlayer player, BlockPos pos, IWrenchAction<P> action, P parameter) {
        Item item = player.func_71045_bC().func_77973_b();
        if (item instanceof IWrench) {
            ((IWrench)item).beforeUse(player, pos);
            action.onWrench(player, pos, parameter);
            ((IWrench)item).afterUse(player, pos);
        }
    }

    public static void wrench(EntityPlayer player, BlockPos pos, IWrenchAction<Void> action) {
        WrenchHelpers.wrench(player, pos, action, null);
    }

    public static abstract class SimpleWrenchAction
    implements IWrenchAction<Void> {
        @Override
        public void onWrench(EntityPlayer player, BlockPos pos, Void parameter) {
            this.onWrench(player, pos);
        }

        public abstract void onWrench(EntityPlayer var1, BlockPos var2);
    }

    public static interface IWrenchAction<P> {
        public void onWrench(EntityPlayer var1, BlockPos var2, P var3);
    }
}

