/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import net.minecraft.entity.player.InventoryPlayer;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.TileInventoryContainerConfigurable;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;

public class ContainerActiveVariableBase<T extends TileActiveVariableBase<?>>
extends TileInventoryContainerConfigurable<T> {
    private final int readValueId = this.getNextValueId();
    private final int readColorId = this.getNextValueId();

    public ContainerActiveVariableBase(InventoryPlayer inventory, T tile) {
        super(inventory, tile);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!MinecraftHelpers.isClientSide()) {
            String readValue = "";
            int readValueColor = 0;
            IVariable<?> variable = ((TileActiveVariableBase)this.getTile()).getVariable(((TileActiveVariableBase)this.getTile()).getNetwork());
            if (variable != null) {
                try {
                    Object value = variable.getValue();
                    readValue = value.getType().toCompactString(value);
                    readValueColor = variable.getType().getDisplayColor();
                }
                catch (NullPointerException | EvaluationException e) {
                    readValue = "ERROR";
                    readValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
                }
            }
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (String)readValue);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)readValueColor);
        }
    }

    public String getReadValue() {
        return ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }
}

