/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionServer;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;

public class ContainerAspectSettings
extends ExtendedInventoryContainer {
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final World world;
    private final BlockPos pos;
    private final IAspect aspect;
    private final BiMap<Integer, IAspectPropertyTypeInstance> propertyIds = HashBiMap.create();

    public ContainerAspectSettings(final EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, IAspect aspect) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.func_130014_f_();
        this.pos = player.func_180425_c();
        this.aspect = aspect;
        this.addPlayerInventory(player.field_71071_by, 8, 131);
        for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
            this.propertyIds.put((Object)this.getNextValueId(), (Object)property);
        }
        this.putButtonAction(3, (IButtonActionServer)new IButtonActionServer<InventoryContainer>(){

            public void onAction(int buttonId, InventoryContainer container) {
                IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)ContainerAspectSettings.this.getTarget().getCenter().getSide());
                BlockPos pos = ContainerAspectSettings.this.getTarget().getCenter().getPos().getBlockPos();
                if (!MinecraftHelpers.isClientSide()) {
                    player.openGui((Object)IntegratedDynamics._instance.getModId(), ((IGuiContainerProvider)ContainerAspectSettings.this.getPartType()).getGuiID(), ContainerAspectSettings.this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        });
    }

    protected void initializeValues() {
        super.initializeValues();
        IAspectProperties properties = this.aspect.getProperties(this.getPartType(), this.getTarget(), this.getPartState());
        for (IAspectPropertyTypeInstance property : this.aspect.getPropertyTypes()) {
            this.setValue(property, (IValue)properties.getValue(property));
        }
    }

    public void setValue(IAspectPropertyTypeInstance property, IValue value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get((Object)property)), (String)property.getType().serialize((IValue)value));
    }

    public IPartState getPartState() {
        return this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public <T extends IValueType<V>, V extends IValue> V getPropertyValue(IAspectPropertyTypeInstance<T, V> property) {
        String value;
        if (this.propertyIds.containsValue(property) && (value = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get(property)))) != null) {
            return property.getType().deserialize(value);
        }
        return null;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        IAspectPropertyTypeInstance property;
        super.onUpdate(valueId, value);
        if (!MinecraftHelpers.isClientSide() && (property = (IAspectPropertyTypeInstance)this.propertyIds.get((Object)valueId)) != null) {
            IAspectProperties aspectProperties = this.getAspect().getProperties(this.getPartType(), this.getTarget(), this.getPartState());
            aspectProperties = aspectProperties.clone();
            Object trueValue = property.getType().deserialize(value.func_74779_i(ValueNotifierHelpers.KEY));
            aspectProperties.setValue(property, trueValue);
            this.getAspect().setProperties(this.getPartType(), this.getTarget(), this.getPartState(), aspectProperties);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerAspectSettings)) {
            return false;
        }
        ContainerAspectSettings other = (ContainerAspectSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        IPartType this$partType = this.getPartType();
        IPartType other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        IAspect this$aspect = this.getAspect();
        IAspect other$aspect = other.getAspect();
        if (this$aspect == null ? other$aspect != null : !this$aspect.equals(other$aspect)) {
            return false;
        }
        BiMap<Integer, IAspectPropertyTypeInstance> this$propertyIds = this.getPropertyIds();
        BiMap<Integer, IAspectPropertyTypeInstance> other$propertyIds = other.getPropertyIds();
        return !(this$propertyIds == null ? other$propertyIds != null : !this$propertyIds.equals(other$propertyIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerAspectSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 0 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 0 : $partContainer.hashCode());
        IPartType $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 0 : $partType.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 0 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        IAspect $aspect = this.getAspect();
        result = result * 59 + ($aspect == null ? 0 : $aspect.hashCode());
        BiMap<Integer, IAspectPropertyTypeInstance> $propertyIds = this.getPropertyIds();
        result = result * 59 + ($propertyIds == null ? 0 : $propertyIds.hashCode());
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IAspect getAspect() {
        return this.aspect;
    }

    public BiMap<Integer, IAspectPropertyTypeInstance> getPropertyIds() {
        return this.propertyIds;
    }

    public String toString() {
        return "ContainerAspectSettings(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", world=" + this.getWorld() + ", pos=" + this.getPos() + ", aspect=" + this.getAspect() + ", propertyIds=" + this.getPropertyIds() + ")";
    }
}

