/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionServer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;

public abstract class ContainerMultipart<P extends IPartType<P, S> & IGuiContainerProvider, S extends IPartState<P>>
extends ExtendedInventoryContainer
implements IDirtyMarkListener {
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final P partType;
    private final World world;
    private final BlockPos pos;
    private final Map<IAspect, Integer> aspectPropertyButtons = Maps.newHashMap();
    protected final EntityPlayer player;

    public ContainerMultipart(EntityPlayer player, PartTarget target, IPartContainer partContainer, P partType) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.func_130014_f_();
        this.pos = player.func_180425_c();
        this.player = player;
        this.putButtonAction(1, (IButtonActionServer)new IButtonActionServer<InventoryContainer>(){

            public void onAction(int buttonId, InventoryContainer container) {
                IGuiContainerProvider gui = ((PartTypeConfigurable)ContainerMultipart.this.getPartType()).getSettingsGuiProvider();
                IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)ContainerMultipart.this.getTarget().getCenter().getSide());
                if (!MinecraftHelpers.isClientSide()) {
                    BlockPos cPos = ContainerMultipart.this.getTarget().getCenter().getPos().getBlockPos();
                    ContainerMultipart.this.player.openGui((Object)gui.getMod(), gui.getGuiID(), ContainerMultipart.this.world, cPos.func_177958_n(), cPos.func_177956_o(), cPos.func_177952_p());
                }
            }
        });
    }

    public S getPartState() {
        return (S)this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerMultipart)) {
            return false;
        }
        ContainerMultipart other = (ContainerMultipart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        P this$partType = this.getPartType();
        P other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Map<IAspect, Integer> this$aspectPropertyButtons = this.getAspectPropertyButtons();
        Map<IAspect, Integer> other$aspectPropertyButtons = other.getAspectPropertyButtons();
        if (this$aspectPropertyButtons == null ? other$aspectPropertyButtons != null : !((Object)this$aspectPropertyButtons).equals(other$aspectPropertyButtons)) {
            return false;
        }
        EntityPlayer this$player = this.getPlayer();
        EntityPlayer other$player = other.getPlayer();
        return !(this$player == null ? other$player != null : !this$player.equals(other$player));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerMultipart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 0 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 0 : $partContainer.hashCode());
        P $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 0 : $partType.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 0 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        Map<IAspect, Integer> $aspectPropertyButtons = this.getAspectPropertyButtons();
        result = result * 59 + ($aspectPropertyButtons == null ? 0 : ((Object)$aspectPropertyButtons).hashCode());
        EntityPlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 0 : $player.hashCode());
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public P getPartType() {
        return this.partType;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Map<IAspect, Integer> getAspectPropertyButtons() {
        return this.aspectPropertyButtons;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public String toString() {
        return "ContainerMultipart(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", world=" + this.getWorld() + ", pos=" + this.getPos() + ", aspectPropertyButtons=" + this.getAspectPropertyButtons() + ", player=" + this.getPlayer() + ")";
    }
}

