/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;

public class ContainerPartSettings
extends ExtendedInventoryContainer {
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final World world;
    private final BlockPos pos;
    private final int lastUpdateValueId;

    public ContainerPartSettings(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.func_130014_f_();
        this.pos = player.func_180425_c();
        this.addPlayerInventory(player.field_71071_by, 8, 31);
        this.lastUpdateValueId = this.getNextValueId();
    }

    public int getLastUpdateValueId() {
        return this.lastUpdateValueId;
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastUpdateValueId, (int)this.getPartType().getUpdateInterval(this.getPartState()));
    }

    public int getLastUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastUpdateValueId);
    }

    public IPartState getPartState() {
        return this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        if (!MinecraftHelpers.isClientSide()) {
            this.getPartType().setUpdateInterval(this.getPartState(), this.getLastUpdateValue());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerPartSettings)) {
            return false;
        }
        ContainerPartSettings other = (ContainerPartSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        IPartType this$partType = this.getPartType();
        IPartType other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        return this.getLastUpdateValueId() == other.getLastUpdateValueId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerPartSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 0 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 0 : $partContainer.hashCode());
        IPartType $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 0 : $partType.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 0 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        result = result * 59 + this.getLastUpdateValueId();
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String toString() {
        return "ContainerPartSettings(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", world=" + this.getWorld() + ", pos=" + this.getPos() + ", lastUpdateValueId=" + this.getLastUpdateValueId() + ")";
    }
}

