/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementTypeRegistry;

public class LogicProgrammerElementTypeRegistry
implements ILogicProgrammerElementTypeRegistry {
    private static final LogicProgrammerElementTypeRegistry INSTANCE = new LogicProgrammerElementTypeRegistry();
    private final Map<String, ILogicProgrammerElementType> namedTypes = Maps.newHashMap();
    private final List<ILogicProgrammerElementType> types = Lists.newLinkedList();

    public static LogicProgrammerElementTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <E extends ILogicProgrammerElementType> E addType(E type) {
        this.types.add(type);
        this.namedTypes.put(type.getName(), type);
        return type;
    }

    @Override
    public List<ILogicProgrammerElementType> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    @Override
    public ILogicProgrammerElementType getType(String name) {
        return this.namedTypes.get(name);
    }
}

