/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;

@SideOnly(value=Side.CLIENT)
public class SubGuiConfigRenderPattern<E extends IGuiInputElement, G extends Gui, C extends Container>
extends SubGuiBox
implements ISubGuiBox {
    protected final E element;
    private final int x;
    private final int y;
    protected final G gui;
    protected final C container;

    public SubGuiConfigRenderPattern(E element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(SubGuiBox.Box.LIGHT);
        this.element = element;
        IConfigRenderPattern configRenderPattern = element.getRenderPattern();
        this.x = baseX + (maxWidth - configRenderPattern.getWidth()) / 2;
        this.y = baseY + (maxHeight - configRenderPattern.getHeight()) / 2;
        this.gui = gui;
        this.container = container;
    }

    protected void drawSlot(int x, int y) {
        this.func_73729_b(x, y, 19, 0, 18, 18);
    }

    @Override
    public void initGui(int guiLeft, int guiTop) {
        super.initGui(guiLeft, guiTop);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        IConfigRenderPattern configRenderPattern = this.element.getRenderPattern();
        int baseX = this.getX() + guiLeft;
        int baseY = this.getY() + guiTop;
        for (Pair<Integer, Integer> slot : configRenderPattern.getSlotPositions()) {
            this.drawSlot(baseX + (Integer)slot.getLeft(), baseY + (Integer)slot.getRight());
        }
        if (configRenderPattern.getSymbolPosition() != null) {
            int width = fontRenderer.func_78256_a(this.element.getSymbol());
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)this.element.getSymbol(), (int)(baseX + (Integer)configRenderPattern.getSymbolPosition().getLeft()), (int)(baseY + (Integer)configRenderPattern.getSymbolPosition().getRight() + 8), (int)width, (float)1.0f, (int)0);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.element.getRenderPattern().getWidth();
    }

    @Override
    public int getHeight() {
        return this.element.getRenderPattern().getHeight();
    }

    protected List<String> getValueTypeTooltip(IValueType<?> valueType) {
        LinkedList lines = Lists.newLinkedList();
        lines.add(valueType.getDisplayColorFormat() + L10NHelpers.localize((String)valueType.getUnlocalizedName()));
        return lines;
    }
}

