/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammer;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeGuiElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeSubGuiRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeElementSubGuiRenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class ValueTypeElement
implements ILogicProgrammerElement<SubGuiConfigRenderPattern, GuiLogicProgrammer, ContainerLogicProgrammer> {
    private ValueTypeGuiElement<GuiLogicProgrammer, ContainerLogicProgrammer> innerGuiElement;

    public ValueTypeElement(IValueType valueType) {
        this.innerGuiElement = new ValueTypeGuiElement(valueType);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public String getMatchString() {
        return this.getLocalizedNameFull().toLowerCase();
    }

    @Override
    public boolean matchesInput(IValueType valueType) {
        return false;
    }

    @Override
    public boolean matchesOutput(IValueType valueType) {
        return ValueHelpers.correspondsTo(this.getInnerGuiElement().getValueType(), valueType);
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)this.getInnerGuiElement().getValueType().getUnlocalizedName());
    }

    @Override
    public void loadTooltip(List<String> lines) {
        this.getInnerGuiElement().loadTooltip(lines);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
    }

    @Override
    public boolean canWriteElementPre() {
        return this.getInnerGuiElement().getInputString() != null && !this.getInnerGuiElement().getInputString().isEmpty();
    }

    @Override
    public ItemStack writeElement(ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(!MinecraftHelpers.isClientSide(), itemStack, ValueTypes.REGISTRY, new ValueTypeVariableFacadeFactory(this.innerGuiElement.getValueType(), this.innerGuiElement.getInputString()));
    }

    @Override
    public boolean canCurrentlyReadFromOtherItem() {
        return this.getInnerGuiElement().getInputString() == null || this.getInnerGuiElement().getInputString().equals(this.getInnerGuiElement().getDefaultInputString());
    }

    @Override
    public void activate() {
        this.getInnerGuiElement().setInputString(new String(this.innerGuiElement.getDefaultInputString()));
    }

    @Override
    public void deactivate() {
        this.getInnerGuiElement().setInputString(null);
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        return this.getInnerGuiElement().getValueType().canDeserialize(this.getInnerGuiElement().getInputString());
    }

    @Override
    public int getColor() {
        return this.getInnerGuiElement().getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getInnerGuiElement().getValueType().getUnlocalizedName());
    }

    @Override
    public boolean isFor(IVariableFacade variableFacade) {
        IValueTypeVariableFacade valueTypeFacade;
        if (variableFacade instanceof IValueTypeVariableFacade && (valueTypeFacade = (IValueTypeVariableFacade)variableFacade).isValid()) {
            return this.getInnerGuiElement().getValueType() == valueTypeFacade.getValueType();
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return itemStack.func_77973_b() == ItemVariable.getInstance();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigRenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
        return new ValueTypeElementSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public void setValue(IValue value, ValueTypeSubGuiRenderPattern activeElementSubGui) {
        this.getInnerGuiElement().setInputString(this.getInnerGuiElement().getValueType().serialize(value), activeElementSubGui);
    }

    public IValue getValue() {
        return this.getInnerGuiElement().getValueType().deserialize(this.getInnerGuiElement().getInputString());
    }

    public ValueTypeGuiElement<GuiLogicProgrammer, ContainerLogicProgrammer> getInnerGuiElement() {
        return this.innerGuiElement;
    }

    protected static class ValueTypeVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade> {
        private final IValueType valueType;
        private final String value;

        public ValueTypeVariableFacadeFactory(IValueType valueType, String value) {
            this.valueType = valueType;
            this.value = value;
        }

        @Override
        public IValueTypeVariableFacade create(boolean generateId) {
            return new ValueTypeVariableFacade(generateId, this.valueType, this.value);
        }

        @Override
        public IValueTypeVariableFacade create(int id) {
            return new ValueTypeVariableFacade(id, this.valueType, this.value);
        }
    }
}

