/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammer;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;

public class ValueTypeItemStackElement<V extends IValue>
extends ValueTypeElement {
    private final IItemStackToValue<V> itemStackToValue;
    private final ILogicProgrammerElementType type;
    private ItemStack itemStack;

    public ValueTypeItemStackElement(IValueType valueType, IItemStackToValue<V> itemStackToValue, ILogicProgrammerElementType type) {
        super(valueType);
        this.itemStackToValue = itemStackToValue;
        this.type = type;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return this.type;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.SINGLE_SLOT;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public boolean canWriteElementPre() {
        return this.itemStack != null;
    }

    @Override
    public ItemStack writeElement(ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(!MinecraftHelpers.isClientSide(), itemStack, ValueTypes.REGISTRY, new ValueTypeVariableFacadeFactory(this.getInnerGuiElement().getValueType(), (IValue)this.itemStackToValue.getValue(this.itemStack)));
    }

    @Override
    public void activate() {
        this.itemStack = null;
    }

    @Override
    public void deactivate() {
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (this.itemStack == null) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalidInputItem", new Object[0]);
        }
        return this.itemStackToValue.validate(this.itemStack);
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigRenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
        return new SubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public static interface IItemStackToValue<V extends IValue> {
        public L10NHelpers.UnlocalizedString validate(ItemStack var1);

        public V getValue(ItemStack var1);
    }

    protected static class ValueTypeVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade> {
        private final IValueType valueType;
        private final IValue value;

        public ValueTypeVariableFacadeFactory(IValueType valueType, IValue value) {
            this.valueType = valueType;
            this.value = value;
        }

        @Override
        public IValueTypeVariableFacade create(boolean generateId) {
            return new ValueTypeVariableFacade<IValue>(generateId, this.valueType, this.value);
        }

        @Override
        public IValueTypeVariableFacade create(int id) {
            return new ValueTypeVariableFacade<IValue>(id, this.valueType, this.value);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SubGuiRenderPattern
    extends SubGuiConfigRenderPattern<ValueTypeItemStackElement, GuiLogicProgrammer, ContainerLogicProgrammer> {
        public SubGuiRenderPattern(ValueTypeItemStackElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            IValueType valueType = ((ValueTypeItemStackElement)this.element).getInnerGuiElement().getValueType();
            if (!((ContainerLogicProgrammer)this.container).hasWriteItemInSlot() && ((GuiLogicProgrammer)this.gui).func_146978_c(232, 110, 18, 18, mouseX, mouseY)) {
                ((GuiLogicProgrammer)this.gui).drawTooltip(this.getValueTypeTooltip(valueType), mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

