/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammer;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeSubGuiRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeListValueChangedPacket;

public class ValueTypeListElement
extends ValueTypeElement {
    private IValueType listValueType;
    private Map<Integer, ValueTypeElement> subElements;
    private Map<Integer, ValueTypeSubGuiRenderPattern> subElementGuis;
    private int length = 0;
    private int activeElement = -1;
    private MasterSubGuiRenderPattern masterGui;
    private ValueTypeList.ValueList serverValue = null;

    public ValueTypeListElement() {
        super(ValueTypes.LIST);
    }

    public void setServerValue(ValueTypeList.ValueList serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.LIST_ELEMENT_TYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS;
    }

    @Override
    public boolean canWriteElementPre() {
        return MinecraftHelpers.isClientSide() ? this.listValueType != null : this.serverValue != null;
    }

    protected List<IValue> constructValues() {
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)this.length);
        for (Map.Entry<Integer, ValueTypeElement> value : this.subElements.entrySet()) {
            if (value.getValue().validate() == null) {
                valueList.add(value.getKey(), value.getValue().getValue());
                continue;
            }
            valueList.add(value.getKey(), this.listValueType.getDefault());
        }
        return valueList;
    }

    @Override
    public ItemStack writeElement(ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        ValueTypeVariableFacadeFactory factory = MinecraftHelpers.isClientSide() ? new ValueTypeVariableFacadeFactory(this.listValueType, this.constructValues()) : new ValueTypeVariableFacadeFactory(this.serverValue);
        return registry.writeVariableFacadeItem(!MinecraftHelpers.isClientSide(), itemStack, ValueTypes.REGISTRY, factory);
    }

    public void setListValueType(IValueType listValueType) {
        this.listValueType = listValueType;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        this.setLength(0);
    }

    public void setLength(int length) {
        this.length = length;
        this.setActiveElement(length - 1);
    }

    public void setActiveElement(int index) {
        this.activeElement = index;
        if (index >= 0 && !this.subElements.containsKey(index)) {
            this.subElements.put(index, LogicProgrammerElementTypes.VALUETYPE.getByValueType(this.listValueType));
        }
        this.masterGui.setActiveElement(this.activeElement);
        this.masterGui.container.onDirty();
    }

    public void removeElement(int index) {
        Map<Integer, ValueTypeElement> oldSubElements = this.subElements;
        Map<Integer, ValueTypeSubGuiRenderPattern> oldSubElementGuis = this.subElementGuis;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        for (Map.Entry<Integer, ValueTypeElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.put(i, entry.getValue());
                this.subElementGuis.put(i, oldSubElementGuis.get(i));
                continue;
            }
            if (i <= index) continue;
            this.subElements.put(i - 1, entry.getValue());
            this.subElementGuis.put(i - 1, oldSubElementGuis.get(i));
        }
        this.setLength(this.length - 1);
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (!MinecraftHelpers.isClientSide()) {
            return this.serverValue == null ? new L10NHelpers.UnlocalizedString() : null;
        }
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeListValueChangedPacket(this.listValueType == null ? ValueTypes.LIST.getDefault() : ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues())));
        }
        if (this.listValueType == null) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalidInputItem", new Object[0]);
        }
        for (Map.Entry<Integer, ValueTypeElement> entry : this.subElements.entrySet()) {
            L10NHelpers.UnlocalizedString error = entry.getValue().validate();
            if (error == null) continue;
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalidListElement", new Object[]{entry.getKey(), error});
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigRenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
        this.masterGui = new MasterSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    protected static class ValueTypeVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade> {
        private final ValueTypeList.ValueList values;

        public ValueTypeVariableFacadeFactory(IValueType valueType, List<IValue> values) {
            this(ValueTypeList.ValueList.ofList(valueType, values));
        }

        public ValueTypeVariableFacadeFactory(ValueTypeList.ValueList values) {
            this.values = values;
        }

        @Override
        public IValueTypeVariableFacade create(boolean generateId) {
            return new ValueTypeVariableFacade<ValueTypeList.ValueList>(generateId, ValueTypes.LIST, this.values);
        }

        @Override
        public IValueTypeVariableFacade create(int id) {
            return new ValueTypeVariableFacade<ValueTypeList.ValueList>(id, ValueTypes.LIST, this.values);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class ListElementSubGui
    extends SubGuiConfigRenderPattern<ValueTypeListElement, GuiLogicProgrammer, ContainerLogicProgrammer> {
        private GuiButtonArrow arrowLeft;
        private GuiButtonArrow arrowRight;
        private GuiButton arrowRemove;

        public ListElementSubGui(ValueTypeListElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            ValueTypeSubGuiRenderPattern subGui = (ValueTypeSubGuiRenderPattern)element.subElementGuis.get(element.activeElement);
            if (subGui == null) {
                subGui = (ValueTypeSubGuiRenderPattern)((ValueTypeElement)element.subElements.get(element.activeElement)).createSubGui(baseX, baseY, maxWidth, maxHeight / 3 * 2, gui, container);
                element.subElementGuis.put(element.activeElement, subGui);
            }
            this.subGuiHolder.addSubGui(subGui);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4 * 3;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new GuiButtonArrow(1, x, y, GuiButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new GuiButtonArrow(1, x + this.getWidth() - this.arrowLeft.field_146120_f - 1, y, GuiButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new GuiButtonText(2, x + this.getWidth() / 2 - this.arrowLeft.field_146120_f / 2, y + this.getHeight() - 13, 12, 12, "-", true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.field_146124_l = ((ValueTypeListElement)this.element).activeElement > 0;
            this.arrowRight.field_146124_l = ((ValueTypeListElement)this.element).activeElement < ((ValueTypeListElement)this.element).length - 1;
            this.arrowRemove.field_146124_l = ((ValueTypeListElement)this.element).length > 0;
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowLeft) {
                ((ValueTypeListElement)this.element).setActiveElement(((ValueTypeListElement)this.element).activeElement - 1);
            } else if (guibutton == this.arrowRight) {
                ((ValueTypeListElement)this.element).setActiveElement(((ValueTypeListElement)this.element).activeElement + 1);
            } else if (guibutton == this.arrowRemove) {
                ((ValueTypeListElement)this.element).removeElement(((ValueTypeListElement)this.element).activeElement);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX() + this.getWidth() / 2;
            int y = guiTop + this.getY() + 4;
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)String.valueOf(((ValueTypeListElement)this.element).activeElement), (int)(x - 4), (int)(y + 2), (int)10, (int)Helpers.RGBToInt((int)20, (int)20, (int)20));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SelectionSubGui
    extends SubGuiConfigRenderPattern<ValueTypeListElement, GuiLogicProgrammer, ContainerLogicProgrammer>
    implements IInputListener {
        private GuiArrowedListField<IValueType> valueTypeSelector = null;
        private GuiButton arrowAdd;

        public SelectionSubGui(ValueTypeListElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IValueType> getValueTypes() {
            return LogicProgrammerElementTypes.VALUETYPE.getValueTypes();
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.valueTypeSelector = new GuiArrowedListField(0, Minecraft.func_71410_x().field_71466_p, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 2, 100, 15, true, true, SelectionSubGui.getValueTypes());
            this.valueTypeSelector.setListener((IInputListener)this);
            this.onChanged();
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new GuiButtonText(1, x + this.getWidth() - 13, y + this.getHeight() - 13, 12, 12, "+", true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            this.valueTypeSelector.func_146192_a(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeListElement)this.element).setLength(((ValueTypeListElement)this.element).length + 1);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }

        public void onChanged() {
            ((ValueTypeListElement)this.element).setListValueType((IValueType)this.valueTypeSelector.getActiveElement());
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class MasterSubGuiRenderPattern
    extends SubGuiConfigRenderPattern<ValueTypeListElement, GuiLogicProgrammer, ContainerLogicProgrammer> {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final GuiLogicProgrammer gui;
        private final ContainerLogicProgrammer container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;

        public MasterSubGuiRenderPattern(ValueTypeListElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammer gui, ContainerLogicProgrammer container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeListElement)this.element, this.baseX, this.baseY + this.getHeight() / 4, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.initGui(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            IValueType valueType = ((ValueTypeListElement)this.element).getInnerGuiElement().getValueType();
            if (!this.container.hasWriteItemInSlot() && this.gui.func_146978_c(232, 110, 18, 18, mouseX, mouseY)) {
                this.gui.drawTooltip(this.getValueTypeTooltip(valueType), mouseX - guiLeft, mouseY - guiTop);
            }
        }
    }
}

