/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.beans.ConstructorProperties;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.network.IEnergyConsumingNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class PartNetworkElement<P extends IPartType<P, S>, S extends IPartState<P>>
implements IPartNetworkElement<P, S>,
IEnergyConsumingNetworkElement<IPartNetwork> {
    private final P part;
    private final PartTarget target;

    protected static DimPos getCenterPos(PartTarget target) {
        return target.getCenter().getPos();
    }

    protected static EnumFacing getCenterSide(PartTarget target) {
        return target.getCenter().getSide();
    }

    protected static DimPos getTargetPos(PartTarget target) {
        return target.getTarget().getPos();
    }

    protected static EnumFacing getTargetSide(PartTarget target) {
        return target.getTarget().getSide();
    }

    @Override
    public IPartContainerFacade getPartContainerFacade() {
        return CableHelpers.getInterface(PartNetworkElement.getCenterPos(this.getTarget()), IPartContainerFacade.class);
    }

    @Override
    public S getPartState() {
        IPartContainerFacade partContainerFacade = this.getPartContainerFacade();
        DimPos dimPos = PartNetworkElement.getCenterPos(this.getTarget());
        if (partContainerFacade != null) {
            IPartContainer partContainer = partContainerFacade.getPartContainer((IBlockAccess)PartNetworkElement.getCenterPos(this.getTarget()).getWorld(), dimPos.getBlockPos());
            if (partContainer != null) {
                return (S)partContainer.getPartState(PartNetworkElement.getCenterSide(this.getTarget()));
            }
            throw new IllegalStateException(String.format("The part container at %s could not be found.", dimPos));
        }
        throw new IllegalStateException(String.format("The part container facade at %s could not be found, instead %s was found.", dimPos, dimPos.getWorld().func_180495_p(dimPos.getBlockPos()).func_177230_c()));
    }

    @Override
    public int getConsumptionRate() {
        return this.getPart().getConsumptionRate(this.getPartState());
    }

    @Override
    public void postUpdate(IPartNetwork network, boolean updated) {
        this.part.postUpdate(network, this.getTarget(), this.getPartState(), updated);
    }

    @Override
    public int getUpdateInterval() {
        return this.part.getUpdateInterval(this.getPartState());
    }

    @Override
    public boolean isUpdate() {
        return this.part.isUpdate(this.getPartState());
    }

    @Override
    public void update(IPartNetwork network) {
        this.part.update(network, this.getTarget(), this.getPartState());
    }

    @Override
    public void beforeNetworkKill(IPartNetwork network) {
        this.part.beforeNetworkKill(network, this.target, this.getPartState());
    }

    @Override
    public void afterNetworkAlive(IPartNetwork network) {
        this.part.afterNetworkAlive(network, this.target, this.getPartState());
    }

    @Override
    public void afterNetworkReAlive(IPartNetwork network) {
        this.part.afterNetworkReAlive(network, this.target, this.getPartState());
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement) {
        this.part.addDrops(this.getTarget(), this.getPartState(), itemStacks, dropMainElement);
    }

    @Override
    public boolean onNetworkAddition(IPartNetwork network) {
        boolean res = network.addPart(this.getPartState().getId(), this.getTarget().getCenter());
        if (res) {
            this.part.onNetworkAddition(network, this.target, this.getPartState());
        }
        return res;
    }

    @Override
    public void onNetworkRemoval(IPartNetwork network) {
        network.removePart(this.getPartState().getId());
        this.part.onNetworkRemoval(network, this.target, this.getPartState());
    }

    @Override
    public void onPreRemoved(IPartNetwork network) {
        this.part.onPreRemoved(network, this.target, this.getPartState());
    }

    @Override
    public void onNeighborBlockChange(IPartNetwork network, IBlockAccess world, Block neighborBlock) {
        this.part.onBlockNeighborChange(network, this.target, this.getPartState(), world, neighborBlock);
    }

    @Override
    public P getNetworkEventListener() {
        return this.getPart();
    }

    public boolean equals(Object o) {
        return o instanceof IPartNetworkElement && this.compareTo((INetworkElement)o) == 0;
    }

    public int hashCode() {
        int result = this.part.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof IPartNetworkElement) {
            IPartNetworkElement p = (IPartNetworkElement)o;
            int compPart = Integer.compare(this.part.hashCode(), p.getPart().hashCode());
            if (compPart == 0) {
                int compPos = PartNetworkElement.getCenterPos(this.getTarget()).compareTo(PartNetworkElement.getCenterPos(p.getTarget()));
                if (compPos == 0) {
                    return PartNetworkElement.getCenterSide(this.getTarget()).compareTo((Enum)PartNetworkElement.getCenterSide(p.getTarget()));
                }
                return compPos;
            }
            return compPart;
        }
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    @ConstructorProperties(value={"part", "target"})
    public PartNetworkElement(P part, PartTarget target) {
        this.part = part;
        this.target = target;
    }

    @Override
    public P getPart() {
        return this.part;
    }

    @Override
    public PartTarget getTarget() {
        return this.target;
    }

    public String toString() {
        return "PartNetworkElement(part=" + this.getPart() + ", target=" + this.getTarget() + ")";
    }
}

