/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.beans.ConstructorProperties;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.client.gui.container.GuiPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public abstract class PartTypeConfigurable<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeBase<P, S> {
    private final IGuiContainerProvider settingsGuiProvider;

    public PartTypeConfigurable(String name, IPartType.RenderPosition renderPosition) {
        super(name, renderPosition);
        if (this.hasSettings()) {
            int guiIDSettings = Helpers.getNewId((ModBase)this.getMod(), (Helpers.IDType)Helpers.IDType.GUI);
            this.settingsGuiProvider = this.constructSettingsGuiProvider(guiIDSettings);
            this.getMod().getGuiHandler().registerGUI(this.settingsGuiProvider, ExtendedGuiHandler.PART);
        } else {
            this.settingsGuiProvider = null;
        }
    }

    protected IGuiContainerProvider constructSettingsGuiProvider(int guiId) {
        return new GuiProviderSettings(guiId, this.getMod());
    }

    public boolean hasSettings() {
        return true;
    }

    public IGuiContainerProvider getSettingsGuiProvider() {
        return this.settingsGuiProvider;
    }

    public static class GuiProviderSettings
    implements IGuiContainerProvider {
        private final int guiID;
        private final ModBase mod;

        public Class<? extends Container> getContainer() {
            return ContainerPartSettings.class;
        }

        public Class<? extends GuiScreen> getGui() {
            return GuiPartSettings.class;
        }

        @ConstructorProperties(value={"guiID", "mod"})
        public GuiProviderSettings(int guiID, ModBase mod) {
            this.guiID = guiID;
            this.mod = mod;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public ModBase getMod() {
            return this.mod;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuiProviderSettings)) {
                return false;
            }
            GuiProviderSettings other = (GuiProviderSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGuiID() != other.getGuiID()) {
                return false;
            }
            ModBase this$mod = this.getMod();
            ModBase other$mod = other.getMod();
            return !(this$mod == null ? other$mod != null : !this$mod.equals(other$mod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GuiProviderSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGuiID();
            ModBase $mod = this.getMod();
            result = result * 59 + ($mod == null ? 0 : $mod.hashCode());
            return result;
        }

        public String toString() {
            return "PartTypeConfigurable.GuiProviderSettings(guiID=" + this.getGuiID() + ", mod=" + this.getMod() + ")";
        }
    }
}

