/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class CablePathElement
implements ICablePathElement {
    private final ICable cable;
    private final DimPos position;

    @Override
    public Set<ICablePathElement> getReachableElements() {
        HashSet elements = Sets.newHashSet();
        World world = this.getPosition().getWorld();
        BlockPos pos = this.getPosition().getBlockPos();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.cable.isConnected(world, pos, side)) continue;
            BlockPos posOffset = pos.func_177972_a(side);
            ICable cable = CableHelpers.getInterface((IBlockAccess)world, posOffset, ICable.class);
            if (cable == null) {
                IntegratedDynamics.clog(Level.ERROR, String.format("The position at %s was incorrectly marked as reachable as cable by %s.", pos, this.getCable()));
                continue;
            }
            elements.add(cable.createPathElement(world, posOffset));
        }
        return elements;
    }

    public boolean equals(Object o) {
        return o instanceof CablePathElement && this.compareTo((CablePathElement)o) == 0;
    }

    @Override
    public int compareTo(ICablePathElement o) {
        return this.position.compareTo(o.getPosition());
    }

    public int hashCode() {
        return this.position.hashCode();
    }

    @ConstructorProperties(value={"cable", "position"})
    public CablePathElement(ICable cable, DimPos position) {
        this.cable = cable;
        this.position = position;
    }

    @Override
    public ICable getCable() {
        return this.cable;
    }

    @Override
    public DimPos getPosition() {
        return this.position;
    }

    public String toString() {
        return "CablePathElement(cable=" + this.getCable() + ", position=" + this.getPosition() + ")";
    }
}

