/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.IPathElementProvider;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class Cluster<E extends IPathElement>
implements Collection<E>,
INBTSerializable {
    private final Set<E> elements;

    public Cluster() {
        this.elements = Sets.newTreeSet();
    }

    public Cluster(TreeSet<E> elements) {
        this.elements = elements;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IPathElement e : this.elements) {
            NBTTagCompound elementTag = new NBTTagCompound();
            elementTag.func_74768_a("dimension", e.getPosition().getWorld().field_73011_w.func_177502_q());
            elementTag.func_74772_a("pos", e.getPosition().getBlockPos().func_177986_g());
            list.func_74742_a((NBTBase)elementTag);
        }
        tag.func_74782_a("list", (NBTBase)list);
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("list", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound elementTag = list.func_150305_b(i);
            int dimensionId = elementTag.func_74762_e("dimension");
            BlockPos pos = BlockPos.func_177969_a((long)elementTag.func_74763_f("pos"));
            if (dimensionId < 0 || dimensionId >= MinecraftServer.func_71276_C().field_71305_c.length) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at the invalid dimension id %s.", dimensionId));
                continue;
            }
            WorldServer world = MinecraftServer.func_71276_C().field_71305_c[dimensionId];
            IPathElementProvider pathElementProvider = CableHelpers.getInterface((IBlockAccess)world, pos, IPathElementProvider.class);
            if (pathElementProvider == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at position %s in world %s because it is no valid network element provider block.", pos, dimensionId));
                continue;
            }
            this.elements.add(pathElementProvider.createPathElement((World)world, pos));
        }
    }

    public Set<E> getElements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<E> this$elements = this.getElements();
        Set<E> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<E> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 0 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(elements=" + this.getElements() + ")";
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getElements().contains(arg0);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getElements().toArray(arg0);
    }

    @Override
    public boolean add(E arg0) {
        return this.getElements().add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getElements().remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getElements().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        return this.getElements().addAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getElements().retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getElements().removeAll(arg0);
    }

    @Override
    public void clear() {
        this.getElements().clear();
    }
}

