/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableFacadeable;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class TileMultipartTicking
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
IPartContainer,
ITileCableNetwork,
ITileCableFacadeable,
PartHelpers.IPartStateHolderCallback {
    private final Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>> partData = Maps.newHashMap();
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private boolean realCable = true;
    @NBTPersist
    private Map<Integer, Boolean> connected = Maps.newHashMap();
    @NBTPersist
    private Map<Integer, Boolean> forceDisconnected = Maps.newHashMap();
    @NBTPersist
    private Map<Integer, Integer> redstoneLevels = Maps.newHashMap();
    @NBTPersist
    private Map<Integer, Boolean> redstoneInputs = Maps.newHashMap();
    @NBTPersist
    private Map<Integer, Integer> lightLevels = Maps.newHashMap();
    private Map<Integer, Integer> previousLightLevels;
    @NBTPersist
    private String facadeBlockName = null;
    @NBTPersist
    private int facadeMeta = 0;
    private IPartNetwork network;

    public void func_145841_b(NBTTagCompound tag) {
        this.func_70296_d();
        super.func_145841_b(tag);
        PartHelpers.writePartsToNBT(this.func_174877_v(), tag, this.partData);
    }

    public void func_145839_a(NBTTagCompound tag) {
        PartHelpers.readPartsFromNBT(this.getNetwork(), this.func_174877_v(), tag, this.partData);
        super.func_145839_a(tag);
    }

    public void setRealCable(boolean realCable) {
        this.realCable = realCable;
        this.sendUpdate();
    }

    public boolean isRealCable() {
        return this.realCable;
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public Map<EnumFacing, IPartType<?, ?>> getParts() {
        return Maps.transformValues(this.partData, (Function)new Function<PartHelpers.PartStateHolder<?, ?>, IPartType<?, ?>>(){

            @Nullable
            public IPartType<?, ?> apply(@Nullable PartHelpers.PartStateHolder<?, ?> input) {
                return input.getPart();
            }
        });
    }

    @Override
    public boolean hasParts() {
        return !this.partData.isEmpty();
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(EnumFacing side, IPartType<P, S> part) {
        return !this.hasPart(side);
    }

    protected void onPartsChanged() {
        this.func_70296_d();
        this.sendUpdate();
    }

    public void setPart(final EnumFacing side, final IPartType part, final IPartState partState) {
        PartHelpers.setPart(this.getNetwork(), this.func_145831_w(), this.func_174877_v(), side, Objects.requireNonNull(part), Objects.requireNonNull(partState), new PartHelpers.IPartStateHolderCallback(){

            @Override
            public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                TileMultipartTicking.this.partData.put(side, PartHelpers.PartStateHolder.of(part, partState));
            }
        });
        this.onPartsChanged();
    }

    @Override
    public IPartType getPart(EnumFacing side) {
        if (!this.partData.containsKey(side)) {
            return null;
        }
        return this.partData.get(side).getPart();
    }

    @Override
    public boolean hasPart(EnumFacing side) {
        return this.partData.containsKey(side);
    }

    @Override
    public IPartType removePart(EnumFacing side, EntityPlayer player) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = this.partData.get(side);
        if (partStateHolder == null) {
            IntegratedDynamics.clog(Level.WARN, "Attempted to remove a part at a side where no part was.");
            return null;
        }
        IPartType<?, ?> removed = partStateHolder.getPart();
        if (this.getNetwork() != null) {
            INetworkElement<IPartNetwork> networkElement = removed.createNetworkElement((IPartContainerFacade)this.getBlock(), DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v()), side);
            if (!this.getNetwork().removeNetworkElementPre(networkElement)) {
                return null;
            }
            LinkedList itemStacks = Lists.newLinkedList();
            networkElement.addDrops(itemStacks, true);
            for (ItemStack itemStack : itemStacks) {
                if (player != null) {
                    ItemStackHelpers.spawnItemStackToPlayer((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)itemStack, (EntityPlayer)player);
                    continue;
                }
                Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)itemStack);
            }
            this.getNetwork().removeNetworkElementPost(networkElement);
        } else {
            IntegratedDynamics.clog(Level.WARN, "Removing a part where no network reference was found.");
            ItemStackHelpers.spawnItemStackToPlayer((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)new ItemStack(removed.getItem()), (EntityPlayer)player);
        }
        IPartType<?, ?> ret = this.partData.remove(side).getPart();
        this.onPartsChanged();
        return ret;
    }

    @Override
    public void setPartState(EnumFacing side, IPartState partState) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = this.partData.get(side);
        if (partStateHolder == null) {
            throw new IllegalArgumentException(String.format("No part at position %s was found to update the state for.", this.getPosition()));
        }
        this.partData.put(side, PartHelpers.PartStateHolder.of(partStateHolder.getPart(), partState));
        this.onPartsChanged();
    }

    @Override
    public IPartState getPartState(EnumFacing side) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = this.partData.get(side);
        if (partStateHolder == null) {
            throw new IllegalArgumentException(String.format("No part at position %s was found to get the state from.", this.getPosition()));
        }
        return partStateHolder.getState();
    }

    @Override
    public boolean hasFacade() {
        return this.facadeBlockName != null && !this.facadeBlockName.isEmpty();
    }

    @Override
    public IBlockState getFacade() {
        if (!this.hasFacade()) {
            return null;
        }
        return BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)this.facadeBlockName, (Object)this.facadeMeta));
    }

    @Override
    public void setFacade(@Nullable IBlockState blockState) {
        if (blockState == null) {
            this.facadeMeta = 0;
            this.facadeBlockName = null;
        } else {
            Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)blockState);
            this.facadeMeta = (Integer)serializedBlockState.getRight();
            this.facadeBlockName = (String)serializedBlockState.getLeft();
        }
        this.sendUpdate();
    }

    public void onUpdateReceived() {
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
    }

    public IExtendedBlockState getConnectionState() {
        IExtendedBlockState extendedState = (IExtendedBlockState)this.getBlock().func_176223_P();
        extendedState = extendedState.withProperty(BlockCable.REALCABLE, (Object)this.isRealCable());
        if (this.connected.isEmpty()) {
            this.updateConnections();
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            extendedState = extendedState.withProperty(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.isForceDisconnected(side) && this.connected.get(side.ordinal()) != false ? 1 : 0));
            extendedState = extendedState.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.hasPart(side) ? this.getPart(side).getRenderPosition() : IPartType.RenderPosition.NONE));
        }
        extendedState = extendedState.withProperty(BlockCable.FACADE, (Object)(this.hasFacade() ? Optional.of((Object)this.getFacade()) : Optional.absent()));
        extendedState = extendedState.withProperty(BlockCable.PARTCONTAINER, (Object)this);
        return extendedState;
    }

    public boolean isForceDisconnected(EnumFacing side) {
        if (!this.isRealCable() || this.hasPart(side)) {
            return true;
        }
        if (!this.forceDisconnected.containsKey(side.ordinal())) {
            return false;
        }
        return this.forceDisconnected.get(side.ordinal());
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.updateConnections();
        }
        if (!MinecraftHelpers.isClientSide()) {
            for (PartHelpers.PartStateHolder<?, ?> partStateHolder : this.partData.values()) {
                if (partStateHolder.getState().isDirtyAndReset()) {
                    this.func_70296_d();
                }
                if (!partStateHolder.getState().isUpdateAndReset()) continue;
                this.sendUpdate();
            }
        }
    }

    protected void updateRedstoneInfo(EnumFacing side) {
        this.sendUpdate();
        this.func_145831_w().func_175685_c(this.func_174877_v(), (Block)this.getBlock());
        this.func_145831_w().func_175685_c(this.field_174879_c.func_177972_a(side.func_176734_d()), (Block)this.getBlock());
    }

    public void setRedstoneLevel(EnumFacing side, int level) {
        if (!this.func_145831_w().field_72995_K) {
            boolean sendUpdate = false;
            if (this.redstoneLevels.containsKey(side.ordinal())) {
                if (this.redstoneLevels.get(side.ordinal()) != level) {
                    sendUpdate = true;
                    this.redstoneLevels.put(side.ordinal(), level);
                }
            } else {
                sendUpdate = true;
                this.redstoneLevels.put(side.ordinal(), level);
            }
            if (sendUpdate) {
                this.updateRedstoneInfo(side);
            }
        }
    }

    public int getRedstoneLevel(EnumFacing side) {
        if (this.redstoneLevels.containsKey(side.ordinal())) {
            return this.redstoneLevels.get(side.ordinal());
        }
        return -1;
    }

    public void setAllowRedstoneInput(EnumFacing side, boolean allow) {
        this.redstoneInputs.put(side.ordinal(), allow);
    }

    public boolean isAllowRedstoneInput(EnumFacing side) {
        if (this.redstoneInputs.containsKey(side.ordinal())) {
            return this.redstoneInputs.get(side.ordinal());
        }
        return false;
    }

    public void disableRedstoneLevel(EnumFacing side) {
        if (!this.func_145831_w().field_72995_K) {
            this.redstoneLevels.remove(side.ordinal());
            this.updateRedstoneInfo(side);
        }
    }

    protected void updateLightInfo(EnumFacing side) {
        this.sendUpdate();
    }

    public void setLightLevel(EnumFacing side, int level) {
        if (!this.func_145831_w().field_72995_K) {
            boolean sendUpdate = false;
            if (this.lightLevels.containsKey(side.ordinal())) {
                if (this.lightLevels.get(side.ordinal()) != level) {
                    sendUpdate = true;
                    this.lightLevels.put(side.ordinal(), level);
                }
            } else {
                sendUpdate = true;
                this.lightLevels.put(side.ordinal(), level);
            }
            if (sendUpdate) {
                this.updateLightInfo(side);
            }
        }
    }

    public int getLightLevel(EnumFacing side) {
        if (this.lightLevels.containsKey(side.ordinal())) {
            return this.lightLevels.get(side.ordinal());
        }
        return 0;
    }

    public static IPartContainer get(DimPos pos) {
        IPartContainerFacade partContainerFacade = CableHelpers.getInterface(pos, IPartContainerFacade.class);
        return partContainerFacade.getPartContainer((IBlockAccess)pos.getWorld(), pos.getBlockPos());
    }

    @Override
    public void resetCurrentNetwork() {
        if (this.network != null) {
            this.setNetwork(null);
        }
    }

    @Override
    public boolean canConnect(ICable connector, EnumFacing side) {
        return !this.isForceDisconnected(side);
    }

    @Override
    public void updateConnections() {
        World world = this.func_145831_w();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean cableConnected = CableNetworkComponent.canSideConnect(world, this.field_174879_c, side, (ICable)this.getBlock());
            this.connected.put(side.ordinal(), cableConnected);
            if (cableConnected) continue;
            this.forceDisconnected.put(side.ordinal(), false);
        }
        this.func_70296_d();
        this.sendUpdate();
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return this.connected.containsKey(side.ordinal()) && this.connected.get(side.ordinal()) != false;
    }

    @Override
    public void disconnect(EnumFacing side) {
        this.forceDisconnected.put(side.ordinal(), true);
    }

    @Override
    public void reconnect(EnumFacing side) {
        this.forceDisconnected.remove(side.ordinal());
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partData;
    }

    public void setPartData(Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>> partData) {
        this.partData.clear();
        this.partData.putAll(partData);
    }

    public Map<Integer, Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(Map<Integer, Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public void silentResetPartData() {
        this.partData.clear();
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        IPartState partState;
        if (facing == null) {
            for (Map.Entry<EnumFacing, PartHelpers.PartStateHolder<?, ?>> entry : this.partData.entrySet()) {
                Object partState2 = entry.getValue().getState();
                if (partState2 == null || !partState2.hasCapability(capability)) continue;
                return true;
            }
        } else if (this.hasPart(facing) && (partState = this.getPartState(facing)) != null && partState.hasCapability(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            for (Map.Entry<EnumFacing, PartHelpers.PartStateHolder<?, ?>> entry : this.partData.entrySet()) {
                T partState = entry.getValue().getState();
                if (partState == null || !partState.hasCapability(capability)) continue;
                return partState.getCapability(capability);
            }
        } else {
            IPartState partState = this.getPartState(facing);
            if (partState != null && partState.hasCapability(capability)) {
                return partState.getCapability(capability);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IPartNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(IPartNetwork network) {
        this.network = network;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

