/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.item.ItemBlockMetadata;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class ItemBlockCable
extends ItemBlockMetadata {
    private static final List<IUseAction> USE_ACTIONS = Lists.newLinkedList();

    public ItemBlockCable(Block block) {
        super(block);
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    protected boolean checkCableAt(World world, BlockPos pos) {
        ICable cable = CableHelpers.getInterface((IBlockAccess)world, pos, ICable.class);
        if (cable instanceof ICableFakeable) {
            return !((ICableFakeable)cable).isRealCable(world, pos);
        }
        return cable != null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        BlockPos target = pos.func_177972_a(side);
        if (this.checkCableAt(world, pos)) {
            return true;
        }
        if (this.checkCableAt(world, target)) {
            return true;
        }
        return world.func_180495_p(target).func_177230_c().func_176200_f(world, pos);
    }

    protected boolean attempItemUseTarget(ItemStack stack, World world, BlockPos pos, BlockCable blockCable) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.isAir((IBlockAccess)world, pos)) {
            ICableFakeable cable = CableHelpers.getInterface((IBlockAccess)world, pos, ICableFakeable.class);
            if (cable != null && !cable.isRealCable(world, pos)) {
                cable.setRealCable(world, pos, true);
                return true;
            }
            for (IUseAction useAction : USE_ACTIONS) {
                if (!useAction.attempItemUseTarget(stack, world, pos, blockCable)) continue;
                return true;
            }
        }
        return false;
    }

    protected void afterItemUse(ItemStack stack, World world, BlockPos pos, BlockCable blockCable, boolean calledSuper) {
        if (!calledSuper) {
            ItemBlockCable.playPlaceSound(world, pos);
            --stack.field_77994_a;
        }
        blockCable.setDisableCollisionBox(false);
    }

    public static void playPlaceSound(World world, BlockPos pos) {
        BlockCable block = BlockCable.getInstance();
        world.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ((Block)block).field_149762_H.func_150496_b(), (((Block)block).field_149762_H.func_150497_c() + 1.0f) / 2.0f, ((Block)block).field_149762_H.func_150494_d() * 0.8f);
    }

    public static void playBreakSound(World world, BlockPos pos, IBlockState blockState) {
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockCable blockCable = (BlockCable)this.field_150939_a;
        blockCable.setDisableCollisionBox(true);
        if (this.attempItemUseTarget(stack, worldIn, pos, blockCable)) {
            this.afterItemUse(stack, worldIn, pos, blockCable, false);
            return true;
        }
        if (this.attempItemUseTarget(stack, worldIn, pos.func_177972_a(side), blockCable)) {
            this.afterItemUse(stack, worldIn, pos, blockCable, false);
            return true;
        }
        boolean ret = super.func_180614_a(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
        this.afterItemUse(stack, worldIn, pos, blockCable, true);
        return ret;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemStack var1, World var2, BlockPos var3, BlockCable var4);
    }
}

