/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableFacadeable;
import org.cyclops.integrateddynamics.client.render.model.FacadeModel;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends ConfigurableItem {
    private static ItemFacade _instance = null;

    public static ItemFacade getInstance() {
        return _instance;
    }

    public ItemFacade(ExtendedConfig eConfig) {
        super(eConfig);
    }

    public IBlockState getFacadeBlock(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            String blockName = tag.func_74779_i("blockName");
            int meta = tag.func_74762_e("meta");
            return BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)blockName, (Object)meta));
        }
        return null;
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        IBlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((IBlockState)blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, IBlockState blockState) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)blockState);
        tag.func_74778_a("blockName", (String)serializedBlockState.getLeft());
        tag.func_74768_a("meta", ((Integer)serializedBlockState.getRight()).intValue());
    }

    public String func_77653_i(ItemStack itemStack) {
        String suffix = EnumChatFormatting.ITALIC + L10NHelpers.localize((String)"general.integrateddynamics.info.none");
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).func_82833_r();
        }
        return super.func_77653_i(itemStack) + " - " + suffix;
    }

    public boolean func_180614_a(ItemStack itemStack, EntityPlayer playerIn, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ITileCableFacadeable facadeContainer = (ITileCableFacadeable)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCableFacadeable.class);
            IBlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeContainer != null && blockState != null && !facadeContainer.hasFacade()) {
                facadeContainer.setFacade(blockState);
                ItemBlockCable.playPlaceSound(world, pos);
                --itemStack.field_77994_a;
            }
            return true;
        }
        return super.func_180614_a(itemStack, playerIn, world, pos, side, hitX, hitY, hitZ);
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new FacadeModel();
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        IBakedModel oldModel;
        FacadeModel.emptyModel = oldModel = (IBakedModel)event.modelRegistry.func_82594_a((Object)this.eConfig.dynamicItemVariantLocation);
        super.onModelBakeEvent(event);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemFacade)) {
            return false;
        }
        ItemFacade other = (ItemFacade)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemFacade;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ItemFacade()";
    }
}

